/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.encryption;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.junit.Assert.fail;
import static org.junit.rules.ExpectedException.none;

import org.mule.encryption.exception.MuleEncryptionException;
import org.mule.encryption.jce.JCEPbeEncrypter;
import org.mule.encryption.key.EncryptionKeyFactory;
import org.mule.encryption.key.SymmetricKeyFactory;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;

import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JCEPbeEncrypterTestCase {

  private static final String PAYLOAD = "Payload to Encrypt";
  private static final String PASSWORD = "a secure password";
  private static final String BASE64_ENCRYPTED_PAYLOAD = "9EdOtFMo1Gg5/BFg7iLwnN26+nO+JA8Kril0rq8hPhg=";

  @Rule
  public ExpectedException expectedException = none();

  private JCEPbeEncrypter encrypter;

  @Before
  public void setup() {
    EncryptionKeyFactory keyFactory = keyFactory(PASSWORD);

    encrypter = new JCEPbeEncrypter("PBEWithHmacSHA256AndAES_128", keyFactory);
  }

  @Test
  public void encryptByteArray() throws MuleEncryptionException {
    byte[] content = PAYLOAD.getBytes();

    byte[] encrypted = encrypter.encrypt(content);

    String base64Encrypted = new String(Base64.getEncoder().encode(encrypted));
    assertThat(base64Encrypted, is(BASE64_ENCRYPTED_PAYLOAD));
  }

  private EncryptionKeyFactory keyFactory(String password) {
    return (SymmetricKeyFactory) () -> {
      try {
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBE");
        return keyFactory.generateSecret(keySpec);
      } catch (InvalidKeySpecException | NoSuchAlgorithmException e) {
        throw new RuntimeException(e);
      }
    };
  }
}
