/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.encryption.jce;

import org.mule.encryption.key.EncryptionKeyFactory;

import java.security.spec.AlgorithmParameterSpec;

import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class JCEPbeEncrypter extends JCEEncrypter {

  public JCEPbeEncrypter(String transformation, EncryptionKeyFactory keyFactory) {
    this(transformation, null, keyFactory);
  }

  public JCEPbeEncrypter(String transformation, String provider, EncryptionKeyFactory keyFactory) {
    super(transformation, provider, keyFactory);
  }

  @Override
  protected AlgorithmParameterSpec getAlgorithmParameterSpec(IvParameterSpec ivParam) {
    return new PBEParameterSpec("12345678".getBytes(), 20, ivParam);
  }
}
