/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.introspection.declaration;

import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.extension.introspection.ConfigurationInstantiator;
import org.mule.extension.introspection.DataQualifier;
import org.mule.extension.introspection.DataType;
import org.mule.extension.introspection.Operation;
import org.mule.extension.introspection.OperationImplementation;
import org.mule.extension.introspection.declaration.ConfigurationDeclaration;
import org.mule.extension.introspection.declaration.Declaration;
import org.mule.extension.introspection.declaration.DeclarationConstruct;
import org.mule.extension.introspection.declaration.OperationDeclaration;
import org.mule.extension.introspection.declaration.OptionalParameterConstruct;
import org.mule.extension.introspection.declaration.ParameterDeclaration;

@RunWith(value=MockitoJUnitRunner.class)
public class DeclarationTestCase {
    public static final String CONFIG_NAME = "config";
    public static final String CONFIG_DESCRIPTION = "Default description";
    public static final String WS_CONSUMER = "WSConsumer";
    public static final String WS_CONSUMER_DESCRIPTION = "Generic Consumer for SOAP Web Services";
    public static final String VERSION = "3.6.0";
    public static final String WSDL_LOCATION = "wsdlLocation";
    public static final String URI_TO_FIND_THE_WSDL = "URI to find the WSDL";
    public static final String SERVICE = "service";
    public static final String SERVICE_NAME = "Service Name";
    public static final String PORT = "port";
    public static final String SERVICE_PORT = "Service Port";
    public static final String ADDRESS = "address";
    public static final String SERVICE_ADDRESS = "Service address";
    public static final String CONSUMER = "consumer";
    public static final String GO_GET_THEM_TIGER = "Go get them tiger";
    public static final String OPERATION = "operation";
    public static final String THE_OPERATION_TO_USE = "The operation to use";
    public static final String MTOM_ENABLED = "mtomEnabled";
    public static final String MTOM_DESCRIPTION = "Whether or not use MTOM for attachments";
    public static final String BROADCAST = "broadcast";
    public static final String BROADCAST_DESCRIPTION = "consumes many services";
    public static final String CALLBACK = "callback";
    public static final String CALLBACK_DESCRIPTION = "async callback";
    public static final String HAS_NO_ARGS = "has no args";
    public static final String ARG_LESS = "argLess";
    private static ConfigurationInstantiator configurationInstantiator;
    private static OperationImplementation consumerImplementation;
    private static OperationImplementation broadcastImplementation;
    private static OperationImplementation argLessImplementation;
    private static Object capability;
    private Declaration declaration;

    public static DeclarationConstruct createConstruct() {
        return new DeclarationTestCase().doCreateConstruct();
    }

    private DeclarationConstruct doCreateConstruct() {
        configurationInstantiator = (ConfigurationInstantiator)Mockito.mock(ConfigurationInstantiator.class);
        consumerImplementation = (OperationImplementation)Mockito.mock(OperationImplementation.class);
        broadcastImplementation = (OperationImplementation)Mockito.mock(OperationImplementation.class);
        argLessImplementation = (OperationImplementation)Mockito.mock(OperationImplementation.class);
        DeclarationConstruct construct = new DeclarationConstruct(WS_CONSUMER, VERSION).describedAs(WS_CONSUMER_DESCRIPTION);
        ((OptionalParameterConstruct)((OptionalParameterConstruct)((OptionalParameterConstruct)((OptionalParameterConstruct)((OptionalParameterConstruct)construct.withCapability(capability).withConfig(CONFIG_NAME).instantiatedWith(configurationInstantiator).describedAs(CONFIG_DESCRIPTION).with().requiredParameter(WSDL_LOCATION).describedAs(URI_TO_FIND_THE_WSDL).ofType(String.class, new Class[0]).whichIsNotDynamic().with().requiredParameter(SERVICE).describedAs(SERVICE_NAME).ofType(String.class, new Class[0]).with().requiredParameter(PORT).describedAs(SERVICE_PORT).ofType(String.class, new Class[0]).withCapability(capability).with().requiredParameter(ADDRESS).describedAs(SERVICE_ADDRESS).ofType(String.class, new Class[0]).withOperation(CONSUMER).describedAs(GO_GET_THEM_TIGER).implementedIn(consumerImplementation).withCapability(capability).with().requiredParameter(OPERATION).describedAs(THE_OPERATION_TO_USE).ofType(String.class, new Class[0]).withCapability(capability).with().optionalParameter(MTOM_ENABLED).describedAs(MTOM_DESCRIPTION)).ofType(Boolean.class, new Class[0])).defaultingTo((Object)true).withOperation(BROADCAST).describedAs(BROADCAST_DESCRIPTION).implementedIn(broadcastImplementation).with().requiredParameter(OPERATION).describedAs(THE_OPERATION_TO_USE).ofType(List.class, new Class[]{String.class}).with().optionalParameter(MTOM_ENABLED).whichIsDynamic()).describedAs(MTOM_DESCRIPTION)).ofType(Boolean.class, new Class[0])).defaultingTo((Object)true).with().requiredParameter(CALLBACK).describedAs(CALLBACK_DESCRIPTION).whichIsNotDynamic().ofType(Operation.class, new Class[0]).withOperation(ARG_LESS).describedAs(HAS_NO_ARGS).implementedIn(argLessImplementation);
        return construct;
    }

    @Before
    public void buildDeclaration() throws Exception {
        this.declaration = DeclarationTestCase.createConstruct().getRootConstruct().getDeclaration();
    }

    @Test
    public void assertDeclaration() {
        Assert.assertThat((Object)this.declaration.getName(), (Matcher)CoreMatchers.is((Object)WS_CONSUMER));
        Assert.assertThat((Object)this.declaration.getDescription(), (Matcher)CoreMatchers.is((Object)WS_CONSUMER_DESCRIPTION));
        Assert.assertThat((Object)this.declaration.getVersion(), (Matcher)CoreMatchers.is((Object)VERSION));
        Assert.assertThat((Object)this.declaration.getConfigurations(), (Matcher)Matchers.hasSize((int)1));
        Set capabilities = this.declaration.getCapabilities();
        Assert.assertThat((Object)capabilities, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)capabilities, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)capabilities, (Matcher)Matchers.contains((Object[])new Object[]{capability}));
    }

    @Test
    public void defaultConfiguration() throws Exception {
        Assert.assertThat((Object)this.declaration.getConfigurations(), (Matcher)Matchers.hasSize((int)1));
        ConfigurationDeclaration configuration = (ConfigurationDeclaration)this.declaration.getConfigurations().get(0);
        Assert.assertThat((Object)configuration, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)configuration.getConfigurationInstantiator(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)configurationInstantiator)));
        Assert.assertThat((Object)configuration.getName(), (Matcher)CoreMatchers.is((Object)CONFIG_NAME));
        Assert.assertThat((Object)configuration.getDescription(), (Matcher)CoreMatchers.is((Object)CONFIG_DESCRIPTION));
        List parameters = configuration.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)4));
        this.assertParameter((ParameterDeclaration)parameters.get(0), WSDL_LOCATION, URI_TO_FIND_THE_WSDL, false, true, DataType.of(String.class), DataQualifier.STRING, null);
        this.assertParameter((ParameterDeclaration)parameters.get(1), SERVICE, SERVICE_NAME, true, true, DataType.of(String.class), DataQualifier.STRING, null);
        this.assertParameter((ParameterDeclaration)parameters.get(2), PORT, SERVICE_PORT, true, true, DataType.of(String.class), DataQualifier.STRING, null);
        this.assertParameter((ParameterDeclaration)parameters.get(3), ADDRESS, SERVICE_ADDRESS, true, true, DataType.of(String.class), DataQualifier.STRING, null);
        Assert.assertThat((Object)((ParameterDeclaration)parameters.get(2)).getCapabilities(), (Matcher)Matchers.contains((Object[])new Object[]{capability}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullCapability() {
        DeclarationTestCase.createConstruct().withCapability(null);
    }

    @Test
    public void operations() throws Exception {
        List operations = this.declaration.getOperations();
        Assert.assertThat((Object)operations, (Matcher)Matchers.hasSize((int)3));
        this.assertConsumeOperation(operations);
        this.assertBroadcastOperation(operations);
        this.assertArgLessOperation(operations);
    }

    private void assertConsumeOperation(List<OperationDeclaration> operations) {
        OperationDeclaration operation = operations.get(0);
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.is((Object)CONSUMER));
        Assert.assertThat((Object)operation.getDescription(), (Matcher)CoreMatchers.is((Object)GO_GET_THEM_TIGER));
        Assert.assertThat((Object)operation.getImplementation(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)consumerImplementation)));
        Assert.assertThat((Object)operation.getCapabilities(), (Matcher)Matchers.contains((Object[])new Object[]{capability}));
        List parameters = operation.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)2));
        this.assertParameter((ParameterDeclaration)parameters.get(0), OPERATION, THE_OPERATION_TO_USE, true, true, DataType.of(String.class), DataQualifier.STRING, null);
        this.assertParameter((ParameterDeclaration)parameters.get(1), MTOM_ENABLED, MTOM_DESCRIPTION, true, false, DataType.of(Boolean.class), DataQualifier.BOOLEAN, true);
        Assert.assertThat((Object)((ParameterDeclaration)parameters.get(0)).getCapabilities(), (Matcher)Matchers.contains((Object[])new Object[]{capability}));
    }

    private void assertBroadcastOperation(List<OperationDeclaration> operations) {
        OperationDeclaration operation = operations.get(1);
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.is((Object)BROADCAST));
        Assert.assertThat((Object)operation.getDescription(), (Matcher)CoreMatchers.is((Object)BROADCAST_DESCRIPTION));
        Assert.assertThat((Object)operation.getImplementation(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)broadcastImplementation)));
        List parameters = operation.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)3));
        this.assertParameter((ParameterDeclaration)parameters.get(0), OPERATION, THE_OPERATION_TO_USE, true, true, DataType.of(List.class, (Class[])new Class[]{String.class}), DataQualifier.LIST, null);
        this.assertParameter((ParameterDeclaration)parameters.get(1), MTOM_ENABLED, MTOM_DESCRIPTION, true, false, DataType.of(Boolean.class), DataQualifier.BOOLEAN, true);
        this.assertParameter((ParameterDeclaration)parameters.get(2), CALLBACK, CALLBACK_DESCRIPTION, false, true, DataType.of(Operation.class), DataQualifier.OPERATION, null);
    }

    private void assertArgLessOperation(List<OperationDeclaration> operations) {
        OperationDeclaration operation = operations.get(2);
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.is((Object)ARG_LESS));
        Assert.assertThat((Object)operation.getDescription(), (Matcher)CoreMatchers.is((Object)HAS_NO_ARGS));
        List parameters = operation.getParameters();
        Assert.assertThat((Object)parameters, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)parameters.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void assertParameter(ParameterDeclaration parameter, String name, String description, boolean acceptsExpressions, boolean required, DataType type, DataQualifier qualifier, Object defaultValue) {
        Assert.assertThat((Object)parameter, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)name));
        Assert.assertThat((Object)parameter.getDescription(), (Matcher)CoreMatchers.is((Object)description));
        Assert.assertThat((Object)parameter.isDynamic(), (Matcher)CoreMatchers.is((Object)acceptsExpressions));
        Assert.assertThat((Object)parameter.isRequired(), (Matcher)CoreMatchers.is((Object)required));
        Assert.assertThat((Object)parameter.getDefaultValue(), (Matcher)CoreMatchers.equalTo((Object)defaultValue));
        Assert.assertThat((Object)parameter.getType(), (Matcher)CoreMatchers.equalTo((Object)type));
        junit.framework.Assert.assertSame((Object)qualifier, (Object)parameter.getType().getQualifier());
    }

    static {
        capability = new Object();
    }
}

