/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.introspection.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mule.extension.introspection.declaration.CapableDeclaration;
import org.mule.extension.introspection.declaration.ConfigurationDeclaration;
import org.mule.extension.introspection.declaration.OperationDeclaration;

public final class Declaration
extends CapableDeclaration<Declaration> {
    private final String name;
    private final String version;
    private String description;
    private List<ConfigurationDeclaration> configurations = new ArrayList<ConfigurationDeclaration>();
    private List<OperationDeclaration> operations = new LinkedList<OperationDeclaration>();

    Declaration(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public List<ConfigurationDeclaration> getConfigurations() {
        return Collections.unmodifiableList(this.configurations);
    }

    public Declaration addConfig(ConfigurationDeclaration config) {
        if (config == null) {
            throw new IllegalArgumentException("Can't add a null config");
        }
        this.configurations.add(config);
        return this;
    }

    public List<OperationDeclaration> getOperations() {
        return Collections.unmodifiableList(this.operations);
    }

    public Declaration addOperation(OperationDeclaration operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Can't add a null operation");
        }
        this.operations.add(operation);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

