/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal;

import org.mule.maven.client.api.model.MavenConfiguration;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;

public class AetherResolutionContext {

  private final MuleMavenResolutionContext adaptedResolutionContext;

  public AetherResolutionContext(MavenConfiguration mavenConfiguration) {
    this.adaptedResolutionContext = new MuleMavenResolutionContext(mavenConfiguration);
  }

  public File getLocalRepositoryLocation() {
    return adaptedResolutionContext.getLocalRepositoryLocation();
  }

  public Optional<AuthenticationSelector> getAuthenticatorSelector() {
    return adaptedResolutionContext.getAuthenticatorSelector();
  }

  public Map<String, Object> getServerConfigurations() {
    return adaptedResolutionContext.getServerConfigurations();
  }

  public List<RemoteRepository> getRemoteRepositories() {
    final List<RemoteRepository> remoteRepositories = adaptedResolutionContext.getRemoteRepositories();
    // maven impl requires this list to be mutable
    return new ArrayList<>(remoteRepositories);
  }

  public List<RemoteRepository> getRemoteRepositoriesWithoutSuperPomModelRepositories() {
    return adaptedResolutionContext.getRemoteRepositoriesWithoutSuperPomModelRepositories();
  }

  public Optional<ProxySelector> getProxySelector() {
    return adaptedResolutionContext.getProxySelector();
  }

  public Optional<MirrorSelector> getMirrorSelector() {
    return adaptedResolutionContext.getMirrorSelector();
  }

  public Optional<Properties> getUserProperties() {
    return adaptedResolutionContext.getUserProperties();
  }

}
