/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal;

import static java.util.Collections.emptyMap;
import static java.util.Optional.empty;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;

import org.apache.maven.model.resolution.ModelResolver;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;

public class AetherRepositoryState {

  private final MuleMavenRepositoryState adaptedRepositoryState;

  public AetherRepositoryState(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader,
                               boolean offline, boolean ignoreArtifactDescriptorRepositories,
                               Optional<AuthenticationSelector> authenticationSelector, boolean updatePolicyNever) {
    this(localRepositoryFolder, workspaceReader, authenticationSelector, empty(), empty(), offline, offline,
         ignoreArtifactDescriptorRepositories, empty(),
         _x -> {
         });
  }

  public AetherRepositoryState(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader,
                               Optional<AuthenticationSelector> authenticationSelector, Optional<ProxySelector> proxySelector,
                               Optional<MirrorSelector> mirrorSelector, boolean noSnapshotUpdates, boolean offline,
                               boolean ignoreArtifactDescriptorRepositories,
                               Optional<Properties> userProperties,
                               Consumer<DefaultRepositorySystemSession> sessionConfigurator) {

    this.adaptedRepositoryState = new MuleMavenRepositoryStateFactory()
        .createMavenRepositoryState(localRepositoryFolder, workspaceReader, authenticationSelector, proxySelector, mirrorSelector,
                                    userProperties
                                        .map(Map.class::cast)
                                        .orElse(emptyMap()),
                                    noSnapshotUpdates, offline, ignoreArtifactDescriptorRepositories, userProperties,
                                    sessionConfigurator);
  }

  public DefaultRepositorySystemSession getSession() {
    return adaptedRepositoryState.getSession();
  }

  public RepositorySystem getSystem() {
    return adaptedRepositoryState.getSystem();
  }

  public ModelResolver createModelResolver(List<RemoteRepository> repositories) {
    return adaptedRepositoryState.createModelResolver(repositories);
  }

  public RemoteRepositoryManager getRemoteRepositoryManager() {
    return adaptedRepositoryState.getRemoteRepositoryManager();
  }

}
