/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.api.model;

/**
 * Immutable implementation of {@link Authentication}
 *
 * @since 1.0.0
 */
class ImmutableAuthentication implements Authentication {

  private String password;
  private String username;

  /**
   * @param username authentication username
   * @param password authentication password
   */
  public ImmutableAuthentication(String username, String password) {
    this.password = password;
    this.username = username;
  }

  @Override
  public String getPassword() {
    return password;
  }

  @Override
  public String getUsername() {
    return username;
  }

  @Override
  public String toString() {
    return "ImmutableAuthentication{" +
        "username='" + password + '\'' +
        ", password='****'" +
        '}';
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    ImmutableAuthentication that = (ImmutableAuthentication) o;

    if (!password.equals(that.password)) {
      return false;
    }
    return username.equals(that.username);
  }

  @Override
  public int hashCode() {
    int result = password.hashCode();
    result = 31 * result + username.hashCode();
    return result;
  }

}
