/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.api.model;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mule.maven.client.api.model.ImmutableMavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;

public interface MavenConfiguration {
    public File getLocalMavenRepositoryLocation();

    public List<RemoteRepository> getMavenRemoteRepositories();

    public Optional<File> getUserSettingsLocation();

    public Optional<File> getGlobalSettingsLocation();

    public boolean getForcePolicyUpdateNever();

    public static MavenConfigurationBuilder newMavenConfigurationBuilder() {
        return new MavenConfigurationBuilder();
    }

    public static class MavenConfigurationBuilder {
        private File localMavenRepository;
        private LinkedList<RemoteRepository> remoteRepositories = new LinkedList();
        private File userSettingsFile;
        private File globalSettingsFile;
        private boolean forcePolicyUpdateNever;

        public MavenConfigurationBuilder localMavenRepositoryLocation(File localMavenRepository) {
            Objects.requireNonNull(localMavenRepository, "localMavenRepository cannot be null");
            this.localMavenRepository = localMavenRepository;
            return this;
        }

        public MavenConfigurationBuilder remoteRepository(RemoteRepository remoteRepository) {
            Objects.requireNonNull(remoteRepository, "remoteRepository cannot be null");
            this.remoteRepositories.addLast(remoteRepository);
            return this;
        }

        public MavenConfigurationBuilder userSettingsLocation(File userSettingsFile) {
            Objects.requireNonNull(userSettingsFile, "userSettingsFile cannot be null");
            this.userSettingsFile = userSettingsFile;
            return this;
        }

        public MavenConfigurationBuilder globalSettingsLocation(File globalSettingsFile) {
            Objects.requireNonNull(globalSettingsFile, "globalSettingsFile cannot be null");
            this.globalSettingsFile = globalSettingsFile;
            return this;
        }

        public MavenConfigurationBuilder forcePolicyUpdateNever(boolean forcePolicyUpdateNever) {
            Objects.requireNonNull(Boolean.valueOf(forcePolicyUpdateNever), "forcePolicyUpdateNever cannot be null");
            this.forcePolicyUpdateNever = forcePolicyUpdateNever;
            return this;
        }

        public MavenConfiguration build() {
            return new ImmutableMavenConfiguration(this.localMavenRepository, this.remoteRepositories, Optional.ofNullable(this.userSettingsFile), Optional.ofNullable(this.globalSettingsFile), this.forcePolicyUpdateNever);
        }
    }
}

