/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.api;

import java.io.File;
import java.util.Optional;

/**
 * Provides a set of suppliers to be used to resolve maven settings.
 *
 * @since 1.0
 */
public interface SettingsSupplierFactory {

  String USER_SETTINGS_SYSTEM_PROPERTY = SettingsSupplierFactory.class.getName() + ".userSettings";

  String GLOBAL_SETTINGS_SYSTEM_PROPERTY = SettingsSupplierFactory.class.getName() + ".globalSettings";

  /**
   * This supplier will try to resolve the maven global settings file based on environment variables.
   * <p>
   * It will try to get the global settings file from MAVEN_CMD_LINE_ARGS environment variable by parsing command line arguments,
   * if not set, then it will try with a environment or system property {@link #GLOBAL_SETTINGS_SYSTEM_PROPERTY}, if not set, finally it  will
   * try to find it from $M2_HOME/conf/settings.xml or $MAVEN_HOME/conf/settings.xml (both environment variables or
   * using system property $maven.home/conf/settings.xml).
   *
   * @return an optional that resolves the maven global settings file based on environment configuration. Or empty optional if couldn't be found.
   */
  Optional<File> environmentGlobalSettingsSupplier();

  /**
   * This supplier will try to resolve the maven user settings file based on the environmentMavenRepositorySupplier.
   * <p>
   * It will try to get the global settings file from MAVEN_CMD_LINE_ARGS environment variable by parsing command line arguments,
   * if not set, then it will try with a environment or system property {@link #USER_SETTINGS_SYSTEM_PROPERTY}, if not set, finally it  will
   * try to get the user settings file from the $USER_HOME/.m2/settings.xml.
   *
   * @return an optional that resolves the user settings file based on environment configuration. Or empty optional if couldn't be found.
   */
  Optional<File> environmentUserSettingsSupplier();

}
