/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.api.model;

import static java.util.Objects.requireNonNull;
import org.mule.api.annotation.NoImplement;

@NoImplement
public interface Authentication {

  /**
   * @return the password to authenticate to the remote repository
   */
  String getPassword();

  /**
   * @return the username to authenticate to the remote repository
   */
  String getUsername();

  /**
   * @return a {@link AuthenticationBuilder} to build an {@link Authentication}.
   */
  static AuthenticationBuilder newAuthenticationBuilder() {
    return new AuthenticationBuilder();
  }

  class AuthenticationBuilder {

    private String password;
    private String username;

    public AuthenticationBuilder password(String password) {
      requireNonNull(password, "password cannot be null");
      this.password = password;
      return this;
    }

    public AuthenticationBuilder username(String username) {
      requireNonNull(username, "username cannot be null");
      this.username = username;
      return this;
    }

    /**
     * Builds the {@link MavenConfiguration} object.
     *
     * @return {@link MavenConfiguration} with the value sets.
     */
    public Authentication build() {
      return new ImmutableAuthentication(username, password);
    }

  }

}
