/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.api;

import org.mule.maven.pom.parser.api.model.BundleDescriptor;

import java.io.File;
import java.util.List;

/**
 * Manages a repository backed by the client.
 *
 * @since 1.1
 */
public interface MavenReactorResolver {

  /**
   * Locates the specified bundle descriptor in the reactor.
   *
   * @param bundleDescriptor The bundleDescriptor to locate, must not be {@code null}.
   * @return The path to the bundleDescriptor or {@code null} if the bundleDescriptor is not available.
   */
  File findArtifact(BundleDescriptor bundleDescriptor);

  /**
   * Determines all available versions of the specified bundleDescriptor.
   *
   * @param bundleDescriptor The bundleDescriptor whose versions should be listed, must not be {@code null}.
   * @return The available versions of the bundleDescriptor, must not be {@code null}.
   */
  List<String> findVersions(BundleDescriptor bundleDescriptor);

}
