/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.api;

import org.mule.maven.client.api.model.BundleDescriptor;

import java.io.File;
import java.util.function.Supplier;

/**
 * Factory class to create {@link Supplier<File>} instances to discover pom files from artifact.
 * 
 * @since 1.0
 */
public interface PomFileSupplierFactory {

  /**
   * Pom file supplier that retrieves the pom file location from an artifact folder.
   * <p>
   * It is expected that the artifact folows the maven convention for the location of the pom file.
   *
   * @param artifactFolder           the folder with the uncompressed maven artifact.
   * @param artifactBundleDescriptor the descriptor of the maven artifact.
   * @return a supplier that retrieves the pom file location from an artifact folder.
   */
  Supplier<File> uncompressPomArtifactSupplier(File artifactFolder, BundleDescriptor artifactBundleDescriptor);

  /**
   * Pom file supplier that retrieves the pom file location from a compressed artifact.
   * <p>
   * It will use a temporary folder to be able to create a {@link File} object to point to.
   *
   * @param artifactFile             the compressed artifact file.
   * @param artifactBundleDescriptor the bundle descriptor.
   * @param temporaryFolder          the temporary folder to use to create the pom file.
   * @return a supplier that retrieves the pom file location from the compressed artifact.
   */
  Supplier<File> compressedArtifactSupplier(File artifactFile, BundleDescriptor artifactBundleDescriptor,
                                            File temporaryFolder);



}
