/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.api;

/**
 * Configuration class for environment-specific settings.
 *
 * <p>
 * This class provides various environment configurations, including whether the environment is FIPS compliant.
 * </p>
 *
 * @since 2.3.0
 */
public interface EnvironmentConfiguration {

  /**
   * Determines if the current environment is FIPS (Federal Information Processing Standards) compliant.
   *
   * @return {@code true} if the environment is FIPS compliant, {@code false} otherwise.
   */
  boolean isFipsEnvironment();
}
