/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.api.model;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.not;

import org.junit.Test;


public class ImmutableAuthenticationTestCase {

  @Test
  public void testGetUsername() {
    ImmutableAuthentication auth = new ImmutableAuthentication("testUser", "testPass");
    assertThat(auth.getUsername(), is("testUser"));
  }

  @Test
  public void testGetPassword() {
    ImmutableAuthentication auth = new ImmutableAuthentication("testUser", "testPass");
    assertThat(auth.getPassword(), is("testPass"));
  }

  @Test
  public void testToStringMasking() {
    ImmutableAuthentication auth = new ImmutableAuthentication("testUser", "testPass");
    String expected = "ImmutableAuthentication{username='****', password='****'}";
    assertThat(auth.toString(), is(expected));
  }

  @Test
  public void testEqualsSameObject() {
    ImmutableAuthentication auth = new ImmutableAuthentication("testUser", "testPass");
    assertThat(auth.equals(auth), is(true));
  }

  @Test
  public void testEqualsDifferentObjectSameValues() {
    ImmutableAuthentication auth1 = new ImmutableAuthentication("testUser", "testPass");
    ImmutableAuthentication auth2 = new ImmutableAuthentication("testUser", "testPass");
    assertThat(auth1.equals(auth2), is(true));
  }

  @Test
  public void testEqualsDifferentUsername() {
    ImmutableAuthentication auth1 = new ImmutableAuthentication("user1", "testPass");
    ImmutableAuthentication auth2 = new ImmutableAuthentication("user2", "testPass");
    assertThat(auth1.equals(auth2), is(false));
  }

  @Test
  public void testEqualsDifferentPassword() {
    ImmutableAuthentication auth1 = new ImmutableAuthentication("testUser", "pass1");
    ImmutableAuthentication auth2 = new ImmutableAuthentication("testUser", "pass2");
    assertThat(auth1.equals(auth2), is(false));
  }

  @Test
  public void testEqualsNullObject() {
    ImmutableAuthentication auth = new ImmutableAuthentication("testUser", "testPass");
    assertThat(auth.equals(null), is(false));
  }

  @Test
  public void testEqualsDifferentClass() {
    ImmutableAuthentication auth = new ImmutableAuthentication("testUser", "testPass");
    Object other = new Object();
    assertThat(auth.equals(other), is(false));
  }

  @Test
  public void testHashCode() {
    ImmutableAuthentication auth1 = new ImmutableAuthentication("testUser", "testPass");
    ImmutableAuthentication auth2 = new ImmutableAuthentication("testUser", "testPass");
    assertThat(auth1.hashCode(), is(auth2.hashCode()));
  }

  @Test
  public void testHashCodeDifferentValues() {
    ImmutableAuthentication auth1 = new ImmutableAuthentication("user1", "testPass");
    ImmutableAuthentication auth2 = new ImmutableAuthentication("user2", "testPass");
    assertThat(auth1.hashCode(), is(not(auth2.hashCode())));
  }
}
