/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.api.exception;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.instanceOf;
import static org.hamcrest.Matchers.is;

import org.junit.Test;

public class IncompatibleMulePluginVersionResolutionExceptionTestCase {

  @Test
  public void testIncompatibleMulePluginVersionResolutionExceptionMessage() {
    String candidateArtifactId = "plugin-1";
    String currentArtifactId = "plugin-2";
    String path = "/path/to/plugin";

    IncompatibleMulePluginVersionResolutionException exception =
        new IncompatibleMulePluginVersionResolutionException(candidateArtifactId, currentArtifactId, path);

    String expectedMessage = "Incompatible Mule plugins versions among: plugin-1, plugin-2. Paths: /path/to/plugin";
    assertThat(exception.getMessage(), is(expectedMessage));
  }

  @Test
  public void testIncompatibleMulePluginVersionResolutionExceptionType() {
    String candidateArtifactId = "plugin-1";
    String currentArtifactId = "plugin-2";
    String path = "/path/to/plugin";

    IncompatibleMulePluginVersionResolutionException exception =
        new IncompatibleMulePluginVersionResolutionException(candidateArtifactId, currentArtifactId, path);

    assertThat(exception, instanceOf(IncompatibleMulePluginVersionResolutionException.class));
  }
}
