/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal;

import static java.lang.System.getProperty;
import static java.lang.System.getenv;

import java.io.File;

/**
 * Utility class to access Maven System Environment and Properties.
 *
 * @since 1.0
 */
public class MavenEnvironmentVariables {

  public static final String MAVEN_CMD_LINE_ARGS = "MAVEN_CMD_LINE_ARGS";
  private static final String M2_HOME = "M2_HOME";
  private static final String MAVEN_HOME = "MAVEN_HOME";
  private static final String MAVEN_HOME_SYSTEM_PROPERTY = "maven.home";

  private static final String USER_HOME = "user.home";
  private static String userHome = getProperty(USER_HOME);

  public String getM2HomeEnv() {
    return getenv(M2_HOME);
  }

  public String getMavenHomeEnv() {
    return getenv(MAVEN_HOME);
  }

  public String getMavenCmdLineArgsEnv() {
    return getenv(MAVEN_CMD_LINE_ARGS);
  }

  public String getUserHome() {
    return userHome;
  }

  public File getSettingsFileAsSystemOrEnvProperty(String systemPropertyName) {
    String property = getProperty(systemPropertyName, null);
    if (property == null) {
      property = System.getenv(systemPropertyName);
    }
    if (property != null) {
      File file = new File(property);
      if (file.exists()) {
        return file;
      }
    }
    return null;
  }

  public String getMavenHomeProperty() {
    return getProperty(MAVEN_HOME_SYSTEM_PROPERTY);
  }
}
