/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal.util;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;
import static org.mule.maven.client.internal.util.VersionChecker.areCompatibleVersions;

import org.junit.Test;

public class VersionCheckerTestCase {

  @Test
  public void compatibleVersions() {
    assertThat(areCompatibleVersions("1", "1"), is(true));
    assertThat(areCompatibleVersions("1", "1.4"), is(true));
    assertThat(areCompatibleVersions("1.2", "1"), is(true));
    assertThat(areCompatibleVersions("1.2", "1.2"), is(true));
    assertThat(areCompatibleVersions("11.2.33", "11.2.55"), is(true));
    assertThat(areCompatibleVersions("11.2.33-FD", "11.2"), is(true));
  }

  @Test
  public void incompatibleVersions() {
    assertThat(areCompatibleVersions("1", "2"), is(false));
    assertThat(areCompatibleVersions("2.1", "1.2"), is(false));
    assertThat(areCompatibleVersions("1.2.4", "5"), is(false));
  }

  @Test
  public void highestVersion() {
    assertThat(VersionChecker.getHighestVersion("1.1", "1.2"), is("1.2"));
    assertThat(VersionChecker.getHighestVersion("2.1", "1.2"), is("2.1"));
    assertThat(VersionChecker.getHighestVersion("3.1", "0.2"), is("3.1"));
    assertThat(VersionChecker.getHighestVersion("1.1", "1.1.2"), is("1.1.2"));
    assertThat(VersionChecker.getHighestVersion("1.1.2", "1.1.2.3"), is("1.1.2.3"));
  }
}
