/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.model.Model;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.filter.PatternInclusionsDependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.eclipse.aether.util.graph.visitor.PathRecordingDependencyVisitor;
import org.mule.maven.client.api.BundleDependenciesResolutionException;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.PomFileSupplierFactory;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.BundleScope;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.AetherRepositoryState;
import org.mule.maven.client.internal.AetherResolutionContext;
import org.mule.maven.client.internal.DefaultPomFileSupplierFactory;
import org.mule.maven.client.internal.MuleArtifactDependencyVisitor;
import org.mule.maven.client.internal.util.MavenUtils;
import org.mule.maven.client.internal.util.Preconditions;
import org.mule.maven.client.internal.util.VersionChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherMavenClient
implements MavenClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AetherMavenClient.class);
    public static final String MULE_PLUGIN_CLASSIFIER = "mule-plugin";
    private static final String POM = "pom";
    private MavenConfiguration mavenConfiguration;
    private AetherResolutionContext aetherResolutionContext;
    private PomFileSupplierFactory pomFileSupplierFactory = new DefaultPomFileSupplierFactory();

    public AetherMavenClient(MavenConfiguration mavenConfiguration) {
        this.mavenConfiguration = mavenConfiguration;
        this.aetherResolutionContext = new AetherResolutionContext(mavenConfiguration);
    }

    public MavenConfiguration getMavenConfiguration() {
        return this.mavenConfiguration;
    }

    public List<BundleDependency> resolveArtifactDependencies(File artifactFile, boolean includeTestDependencies, Optional<File> localRepositoryLocationSupplier, Optional<File> temporaryFolder) {
        return this.resolveArtifactDependencies(artifactFile, includeTestDependencies, false, localRepositoryLocationSupplier, temporaryFolder);
    }

    private List<BundleDependency> resolveArtifactDependencies(File artifactFile, boolean includeTestDependencies, boolean includeProvidedDependencies, Optional<File> localRepositoryLocationSupplier, Optional<File> temporaryFolder) {
        Supplier pomFileSupplier;
        Model pomModel = MavenUtils.getPomModel(artifactFile);
        BundleDescriptor bundleDescriptor = this.getBundleDescriptor(pomModel);
        if (artifactFile.isDirectory()) {
            pomFileSupplier = this.pomFileSupplierFactory.uncompressPomArtifactSupplier(artifactFile, bundleDescriptor);
        } else {
            Preconditions.checkState(temporaryFolder.isPresent(), "temporary folder not provided but the artifact is compressed");
            pomFileSupplier = this.pomFileSupplierFactory.compressedArtifactSupplier(artifactFile, bundleDescriptor, temporaryFolder.get());
        }
        File localRepositoryLocation = localRepositoryLocationSupplier.orElse(this.aetherResolutionContext.getLocalRepositoryLocation());
        AetherRepositoryState repositoryState = new AetherRepositoryState(localRepositoryLocation, Optional.of(new PomWorkspaceReader(bundleDescriptor, artifactFile, pomFileSupplier)), this.aetherResolutionContext.getAuthenticatorSelector(), this.mavenConfiguration.getForcePolicyUpdateNever());
        DefaultArtifact artifact = new DefaultArtifact(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), null, POM, pomModel.getVersion() != null ? pomModel.getVersion() : pomModel.getParent().getVersion());
        try {
            return this.resolveArtifactDependencies(includeTestDependencies, includeProvidedDependencies, repositoryState, (Artifact)artifact);
        }
        catch (DependencyResolutionException e) {
            DependencyNode node = e.getResult().getRoot();
            this.logUnresolvedArtifacts(node, e);
            throw new RuntimeException(String.format("There was an issue solving the dependencies for the artifact [%s]", artifactFile.getAbsolutePath()), e);
        }
        catch (DependencyCollectionException e) {
            throw new RuntimeException(String.format("There was an issue resolving the dependency tree for the artifact [%s]", artifactFile.getAbsolutePath()), e);
        }
        catch (ArtifactDescriptorException e) {
            throw new RuntimeException(String.format("There was an issue resolving the artifact descriptor for the artifact [%s]", artifactFile.getAbsolutePath()), e);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private List<BundleDependency> resolveArtifactDependencies(boolean includeTestDependencies, boolean includeProvidedDependencies, AetherRepositoryState repositoryState, Artifact artifact) throws RepositoryException {
        ArtifactResult artifactResult = this.readArtifactDescriptor(artifact, repositoryState);
        return this.assemblyDependenciesFromPom(repositoryState, artifactResult.getArtifact(), includeTestDependencies, includeProvidedDependencies);
    }

    public List<BundleDependency> resolveBundleDescriptorDependencies(boolean includeTestDependencies, BundleDescriptor bundleDescriptor) {
        return this.resolveBundleDescriptorDependencies(includeTestDependencies, false, bundleDescriptor);
    }

    public List<BundleDependency> resolveBundleDescriptorDependencies(boolean includeTestDependencies, boolean includeProvidedDependencies, BundleDescriptor bundleDescriptor) {
        String[] stringArray;
        if (includeTestDependencies) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "provided";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "provided";
            stringArray = stringArray3;
            stringArray3[1] = "test";
        }
        ScopeDependencyFilter transitiveDependenciesFilter = new ScopeDependencyFilter(stringArray);
        return this.resolveBundleDescriptorDependencies(includeTestDependencies, includeProvidedDependencies, bundleDescriptor, (node, parents) -> true, (DependencyFilter)transitiveDependenciesFilter);
    }

    public List<BundleDependency> resolveBundleDescriptorDependencies(boolean includeTestDependencies, boolean includeProvidedDependencies, BundleDescriptor bundleDescriptor, DependencyFilter directDependencyFilter, DependencyFilter transitiveDependencyFilter) {
        try {
            AetherRepositoryState repositoryState = new AetherRepositoryState(this.aetherResolutionContext.getLocalRepositoryLocation(), Optional.empty(), this.aetherResolutionContext.getAuthenticatorSelector(), this.mavenConfiguration.getForcePolicyUpdateNever());
            Artifact artifact = this.createArtifactFromBundleDescriptor(bundleDescriptor);
            ArtifactResult artifactResult = this.readArtifactDescriptor(artifact, repositoryState);
            return this.assemblyDependenciesFromPom(repositoryState, artifactResult.getArtifact(), includeTestDependencies, includeProvidedDependencies, directDependencyFilter, transitiveDependencyFilter);
        }
        catch (RepositoryException e) {
            throw new BundleDependenciesResolutionException((Throwable)e);
        }
    }

    public List<BundleDependency> resolveBundleDescriptorDependenciesWithWorkspaceReader(File artifactFile, boolean includeTestDependencies, boolean includeProvidedDependencies, BundleDescriptor bundleDescriptor, DependencyFilter directDependencyFilter, DependencyFilter transitiveDependencyFilter) {
        Supplier pomFileSupplier = this.pomFileSupplierFactory.uncompressPomArtifactSupplier(artifactFile, bundleDescriptor);
        try {
            AetherRepositoryState repositoryState = new AetherRepositoryState(this.aetherResolutionContext.getLocalRepositoryLocation(), Optional.of(new PomWorkspaceReader(bundleDescriptor, artifactFile, pomFileSupplier)), this.aetherResolutionContext.getAuthenticatorSelector(), this.mavenConfiguration.getForcePolicyUpdateNever());
            Artifact artifact = this.createArtifactFromBundleDescriptor(bundleDescriptor);
            ArtifactResult artifactResult = this.readArtifactDescriptor(artifact, repositoryState);
            return this.assemblyDependenciesFromPom(repositoryState, artifactResult.getArtifact(), includeTestDependencies, includeProvidedDependencies, directDependencyFilter, transitiveDependencyFilter);
        }
        catch (RepositoryException e) {
            throw new BundleDependenciesResolutionException((Throwable)e);
        }
    }

    private Artifact createArtifactFromBundleDescriptor(BundleDescriptor bundleDescriptor) {
        return new DefaultArtifact(bundleDescriptor.getGroupId(), bundleDescriptor.getArtifactId(), (String)bundleDescriptor.getClassifier().orElse(null), bundleDescriptor.getType(), bundleDescriptor.getVersion());
    }

    public BundleDependency resolveBundleDescriptor(BundleDescriptor bundleDescriptor) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolving artifact with resolution context: " + this.aetherResolutionContext.toString());
            }
            AetherRepositoryState repositoryState = new AetherRepositoryState(this.aetherResolutionContext.getLocalRepositoryLocation(), Optional.empty(), this.aetherResolutionContext.getAuthenticatorSelector(), this.mavenConfiguration.getForcePolicyUpdateNever());
            Artifact artifact = this.createArtifactFromBundleDescriptor(bundleDescriptor);
            ArtifactRequest artifactRequest = new ArtifactRequest(artifact, this.aetherResolutionContext.getRemoteRepositories(), null);
            ArtifactResult artifactResult = repositoryState.getSystem().resolveArtifact((RepositorySystemSession)repositoryState.getSession(), artifactRequest);
            Artifact resolvedArtifact = artifactResult.getArtifact();
            return AetherMavenClient.artifactToBundleDependency(resolvedArtifact, "compile");
        }
        catch (ArtifactResolutionException e) {
            throw new BundleDependenciesResolutionException((Throwable)e);
        }
    }

    public Model getRawPomModel(File artifactFile) {
        return MavenUtils.getPomModel(artifactFile);
    }

    public List<BundleDependency> resolvePluginBundleDescriptorsDependencies(List<BundleDescriptor> bundleDescriptors) {
        HashMap<Pair<String, String>, BundleDependency> plugins = new HashMap<Pair<String, String>, BundleDependency>();
        for (BundleDescriptor bundleDescriptor : bundleDescriptors) {
            BundleDependency directBundleDependency = this.resolveBundleDescriptor(bundleDescriptor);
            plugins.put(this.descriptorToPair(directBundleDependency), directBundleDependency);
            List<BundleDependency> bundleDependencies = this.resolveBundleDescriptorDependencies(false, bundleDescriptor);
            bundleDependencies.stream().filter(bundleDependency -> MULE_PLUGIN_CLASSIFIER.equals(bundleDependency.getDescriptor().getClassifier().orElse(null))).forEach(bundleDependency -> {
                Pair<String, String> key = this.descriptorToPair((BundleDependency)bundleDependency);
                if (plugins.containsKey(key)) {
                    String bundleDescriptorVersion;
                    BundleDependency existentDependency = (BundleDependency)plugins.get(key);
                    String existentBundleDescriptorVersion = existentDependency.getDescriptor().getVersion();
                    if (!VersionChecker.areCompatibleVersions(existentBundleDescriptorVersion, bundleDescriptorVersion = bundleDependency.getDescriptor().getVersion())) throw new RuntimeException(String.format("Incompatible versions between plugin %s and %s", existentDependency.getDescriptor(), bundleDependency.getDescriptor()));
                    String highestVersion = VersionChecker.getHighestVersion(existentBundleDescriptorVersion, bundleDescriptorVersion);
                    if (!highestVersion.equals(bundleDescriptorVersion)) return;
                    plugins.put(key, (BundleDependency)bundleDependency);
                    return;
                } else {
                    plugins.put(key, (BundleDependency)bundleDependency);
                }
            });
        }
        return plugins.values().stream().collect(Collectors.toList());
    }

    private Pair<String, String> descriptorToPair(BundleDependency bundleDependency) {
        return Pair.of((Object)bundleDependency.getDescriptor().getGroupId(), (Object)bundleDependency.getDescriptor().getArtifactId());
    }

    private List<BundleDependency> loadDependencies(List<Dependency> mavenDependencies) {
        ArrayList<BundleDependency> dependencies = new ArrayList<BundleDependency>();
        mavenDependencies.stream().forEach(dependency -> {
            Artifact artifact = dependency.getArtifact();
            dependencies.add(AetherMavenClient.artifactToBundleDependency(artifact, dependency.getScope()));
        });
        return dependencies;
    }

    static BundleDependency artifactToBundleDependency(Artifact artifact, String scope) {
        BundleDescriptor.Builder bundleDescriptorBuilder = new BundleDescriptor.Builder().setArtifactId(artifact.getArtifactId()).setGroupId(artifact.getGroupId()).setVersion(artifact.getVersion()).setBaseVersion(artifact.getBaseVersion()).setType(artifact.getExtension());
        String classifier = artifact.getClassifier();
        if (!org.eclipse.aether.util.StringUtils.isEmpty((String)classifier)) {
            bundleDescriptorBuilder.setClassifier(classifier);
        }
        BundleDependency.Builder builder = new BundleDependency.Builder().setDescriptor(bundleDescriptorBuilder.build()).setScope(BundleScope.valueOf((String)scope.toUpperCase()));
        if (!scope.equalsIgnoreCase("provided")) {
            builder.setBundleUri(artifact.getFile().toURI());
        }
        return builder.build();
    }

    private ArtifactResult readArtifactDescriptor(Artifact artifact, AetherRepositoryState repositoryState) throws ArtifactResolutionException {
        return repositoryState.getSystem().resolveArtifact((RepositorySystemSession)repositoryState.getSession(), new ArtifactRequest(artifact, this.aetherResolutionContext.getRemoteRepositories(), null));
    }

    public List<BundleDependency> assemblyDependenciesFromPom(AetherRepositoryState repositoryState, Artifact artifact, boolean enableTestDependencies, boolean enableProvidedDependencies) throws RepositoryException {
        String[] stringArray;
        if (enableTestDependencies) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "provided";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "provided";
            stringArray = stringArray3;
            stringArray3[1] = "test";
        }
        ScopeDependencyFilter transitiveDependenciesFilter = new ScopeDependencyFilter(stringArray);
        return this.assemblyDependenciesFromPom(repositoryState, artifact, enableTestDependencies, enableProvidedDependencies, (node, parents) -> true, (DependencyFilter)transitiveDependenciesFilter);
    }

    private List<BundleDependency> assemblyDependenciesFromPom(AetherRepositoryState repositoryState, Artifact artifact, boolean enableTestDependencies, boolean enableProvidedDependencies, DependencyFilter directDependenciesFilter, DependencyFilter transitiveDependenciesFilter) throws RepositoryException {
        DefaultArtifact defaultArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), null, POM, artifact.getVersion() != null ? artifact.getVersion() : artifact.getVersion());
        LOGGER.info("About to fetch required dependencies for artifact: {}. This may take a while...", (Object)ArtifactIdUtils.toId((Artifact)defaultArtifact));
        CollectRequest collectRequest = new CollectRequest();
        ArtifactDescriptorResult artifactDescriptorResult = repositoryState.getSystem().readArtifactDescriptor((RepositorySystemSession)repositoryState.getSession(), new ArtifactDescriptorRequest((Artifact)defaultArtifact, null, null).setRepositories(this.aetherResolutionContext.getRemoteRepositories()));
        List dependencies = artifactDescriptorResult.getDependencies();
        List requestedDependencies = dependencies.stream().filter(dependency -> (enableTestDependencies && dependency.getScope().equalsIgnoreCase("test") || dependency.getScope().equalsIgnoreCase("compile") || enableProvidedDependencies && dependency.getScope().equalsIgnoreCase("provided")) && directDependenciesFilter.accept((DependencyNode)new DefaultDependencyNode(dependency), Collections.emptyList())).collect(Collectors.toList());
        LOGGER.debug("Resolving dependencies for: {} from list of dependencies: {}", (Object)ArtifactIdUtils.toId((Artifact)defaultArtifact), requestedDependencies);
        collectRequest.setDependencies(requestedDependencies);
        collectRequest.setManagedDependencies(artifactDescriptorResult.getManagedDependencies());
        collectRequest.setRepositories(this.aetherResolutionContext.getRemoteRepositories());
        LOGGER.debug("Collecting transitive dependencies of artifact: {} using request: {}", (Object)ArtifactIdUtils.toId((Artifact)defaultArtifact), (Object)collectRequest);
        CollectResult collectResult = repositoryState.getSystem().collectDependencies((RepositorySystemSession)repositoryState.getSession(), collectRequest);
        DependencyRequest dependencyRequest = new DependencyRequest();
        dependencyRequest.setFilter(transitiveDependenciesFilter);
        dependencyRequest.setRoot(collectResult.getRoot());
        dependencyRequest.setCollectRequest(collectRequest);
        LOGGER.debug("Collecting and resolving transitive dependencies of artifact: {}", (Object)ArtifactIdUtils.toId((Artifact)defaultArtifact));
        DependencyResult dependencyResult = repositoryState.getSystem().resolveDependencies((RepositorySystemSession)repositoryState.getSession(), dependencyRequest);
        MuleArtifactDependencyVisitor muleArtifactDependencyVisitor = new MuleArtifactDependencyVisitor();
        muleArtifactDependencyVisitor.visit(dependencyResult.getRoot());
        return muleArtifactDependencyVisitor.getBundleDependencies();
    }

    public List<BundleDependency> resolveApplicationBundleDependencies(File pomFile, File targetFolder) {
        Model pomModel = MavenUtils.getPomModelFromFile(pomFile);
        BundleDescriptor bundleDescriptor = this.getBundleDescriptor(pomModel);
        List<BundleDependency> nonMulePluginDependencies = this.resolveNonMulePluginDependencies(targetFolder, bundleDescriptor);
        List<BundleDependency> muleDependencies = this.resolveMulePluginDependencies(targetFolder, bundleDescriptor);
        HashSet<BundleDependency> bundleDependencies = new HashSet<BundleDependency>();
        bundleDependencies.addAll(nonMulePluginDependencies);
        bundleDependencies.addAll(muleDependencies);
        return new ArrayList<BundleDependency>(bundleDependencies);
    }

    private List<BundleDependency> resolveNonMulePluginDependencies(File targetFolder, BundleDescriptor bundleDescriptor) {
        DependencyFilter mulePluginFilter = (node, parents) -> node != null && node.getArtifact() != null && !MULE_PLUGIN_CLASSIFIER.equals(node.getArtifact().getClassifier());
        return this.resolveBundleDescriptorDependenciesWithWorkspaceReader(targetFolder, false, false, bundleDescriptor, mulePluginFilter, mulePluginFilter);
    }

    private List<BundleDependency> resolveMulePluginDependencies(File targetFolder, BundleDescriptor bundleDescriptor) {
        DependencyFilter notMulePluginFilter = (node, parents) -> node != null && node.getArtifact() != null && MULE_PLUGIN_CLASSIFIER.equals(node.getArtifact().getClassifier());
        List<BundleDependency> muleDependencies = this.resolveBundleDescriptorDependenciesWithWorkspaceReader(targetFolder, false, false, bundleDescriptor, notMulePluginFilter, notMulePluginFilter);
        ArrayList<BundleDependency> muleDependenciesDependencies = new ArrayList<BundleDependency>();
        for (BundleDependency muleDependency : muleDependencies) {
            muleDependenciesDependencies.addAll(this.resolveBundleDescriptorDependencies(false, false, muleDependency.getDescriptor()));
        }
        muleDependencies.addAll(muleDependenciesDependencies);
        return muleDependencies;
    }

    private void logUnresolvedArtifacts(DependencyNode node, DependencyResolutionException e) {
        List artifactResults = e.getResult().getArtifactResults().stream().filter(artifactResult -> !artifactResult.getExceptions().isEmpty()).collect(Collectors.toList());
        List patternInclusion = artifactResults.stream().map(artifactResult -> ArtifactIdUtils.toId((Artifact)artifactResult.getRequest().getArtifact())).collect(Collectors.toList());
        PathRecordingDependencyVisitor visitor = new PathRecordingDependencyVisitor((DependencyFilter)new PatternInclusionsDependencyFilter(patternInclusion), node.getArtifact() != null);
        node.accept((DependencyVisitor)visitor);
        visitor.getPaths().stream().forEach(path -> {
            List unresolvedArtifactPath = path.stream().filter(dependencyNode -> dependencyNode.getArtifact() != null).collect(Collectors.toList());
            if (!unresolvedArtifactPath.isEmpty()) {
                LOGGER.warn("Dependency path to not resolved artifacts -> " + unresolvedArtifactPath.toString());
            }
        });
    }

    private BundleDescriptor getBundleDescriptor(Model pomModel) {
        String version = StringUtils.isNotBlank((CharSequence)pomModel.getVersion()) ? pomModel.getVersion() : pomModel.getParent().getVersion();
        return new BundleDescriptor.Builder().setGroupId(StringUtils.isNotBlank((CharSequence)pomModel.getGroupId()) ? pomModel.getGroupId() : pomModel.getParent().getGroupId()).setArtifactId(pomModel.getArtifactId()).setVersion(version).setBaseVersion(version).setType(POM).build();
    }

    private class PomWorkspaceReader
    implements WorkspaceReader {
        final WorkspaceRepository workspaceRepository;
        private final BundleDescriptor bundleDescriptor;
        private final Supplier<File> pomFileSupplier;

        PomWorkspaceReader(BundleDescriptor bundleDescriptor, File artifactFile, Supplier<File> pomFileSupplier) {
            this.bundleDescriptor = bundleDescriptor;
            this.workspaceRepository = new WorkspaceRepository(String.format("worskpace-repository-%s", artifactFile.getName()));
            this.pomFileSupplier = pomFileSupplier;
        }

        public WorkspaceRepository getRepository() {
            return this.workspaceRepository;
        }

        public File findArtifact(Artifact artifact) {
            if (this.checkArtifact(artifact)) {
                return this.pomFileSupplier.get();
            }
            return null;
        }

        public List<String> findVersions(Artifact artifact) {
            if (this.checkArtifact(artifact)) {
                return Collections.singletonList(artifact.getVersion());
            }
            return Collections.emptyList();
        }

        private boolean checkArtifact(Artifact artifact) {
            return this.bundleDescriptor.getGroupId().equals(artifact.getGroupId()) && this.bundleDescriptor.getArtifactId().equals(artifact.getArtifactId()) && this.bundleDescriptor.getVersion().equals(artifact.getVersion()) && this.bundleDescriptor.getType().equals(artifact.getExtension());
        }
    }
}

