/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal.util;

import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.profile.DefaultProfileSelector;
import org.apache.maven.model.profile.DefaultProfileActivationContext;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.ProfileSelector;
import org.apache.maven.model.profile.activation.JdkVersionProfileActivator;
import org.apache.maven.model.profile.activation.OperatingSystemProfileActivator;
import org.apache.maven.model.profile.activation.PropertyProfileActivator;
import org.apache.maven.settings.Settings;

import java.util.ArrayList;

public class MavenModelUtils {

  public static ProfileSelector getProfileSelector() {
    DefaultProfileSelector profileSelector = new DefaultProfileSelector();
    profileSelector.addProfileActivator(new JdkVersionProfileActivator());
    profileSelector.addProfileActivator(new OperatingSystemProfileActivator());
    profileSelector.addProfileActivator(new PropertyProfileActivator());

    return profileSelector;
  }

  public static Profile toModelProfile(org.apache.maven.settings.Profile profile) {
    Profile p = new org.apache.maven.model.Profile();
    org.apache.maven.settings.Activation activation = profile.getActivation();
    if (activation != null) {
      Activation a = new Activation();
      a.setActiveByDefault(activation.isActiveByDefault());
      a.setJdk(activation.getJdk());
      a.setOs(toModelActivationOS(activation.getOs()));
      a.setProperty(toModelActivationProperty(activation.getProperty()));

      p.setActivation(a);
    }
    p.setSource(profile.getSourceLevel());
    p.setId(profile.getId());
    return p;
  }

  private static ActivationOS toModelActivationOS(org.apache.maven.settings.ActivationOS activationOS) {
    if (activationOS == null) {
      return null;
    }
    ActivationOS activation = new ActivationOS();
    activation.setArch(activationOS.getArch());
    activation.setFamily(activationOS.getFamily());
    activation.setName(activationOS.getName());
    activation.setVersion(activationOS.getVersion());
    return activation;
  }

  private static ActivationProperty toModelActivationProperty(org.apache.maven.settings.ActivationProperty activationProperty) {
    if (activationProperty == null) {
      return null;
    }
    ActivationProperty activation = new ActivationProperty();
    activation.setName(activationProperty.getName());
    activation.setValue(activationProperty.getValue());
    return activation;
  }

  public static ProfileActivationContext getProfileActivationContext(Settings mavenSettings) {
    DefaultProfileActivationContext context = new DefaultProfileActivationContext();
    context.setActiveProfileIds(mavenSettings.getActiveProfiles());
    // TODO: set inactive profile ids?
    context.setInactiveProfileIds(new ArrayList<>());
    context.setSystemProperties(System.getProperties());
    return context;
  }

  public static ModelProblemCollector getModelProblemCollector() {
    return (req) -> {
    };
  }
}
