/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal;

import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;

/**
 * Restore original artifacts on all dependencies modified by the {@link ParentContextDependencyGraphTransformer}
 *
 * @since 1.5.0
 */
public class ArtifactRestorerTransformer extends GraphCycleAvoidingTransformer {

  public static final String ORIGINAL_ARTIFACT_KEY = "nodeOriginalArtifact";

  @Override
  protected void transformNode(DependencyNode node) {
    if (node.getData().containsKey(ORIGINAL_ARTIFACT_KEY)) {
      node.setArtifact((Artifact) node.getData().remove(ORIGINAL_ARTIFACT_KEY));
    }
  }

}
