/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.BundleScope;

public class BundleDependencyHelper {
    private static final String ROOT_CONTEXT = "ROOT";
    private Map<String, Map<BundleDescriptor, BundleDependency>> contexts = new HashMap<String, Map<BundleDescriptor, BundleDependency>>();

    public BundleDependency getBundleDependency(DependencyNode node, DependencyFilter transitiveDependencyFilter) {
        Map context = this.contexts.computeIfAbsent(ROOT_CONTEXT, k -> new HashMap());
        return this.getBundleDependency(node, context, transitiveDependencyFilter);
    }

    private BundleDependency getBundleDependency(DependencyNode node, Map<BundleDescriptor, BundleDependency> context, DependencyFilter transitiveDependencyFilter) {
        Artifact artifact;
        BundleDescriptor bundleDescriptor;
        BundleDependency cachedValue;
        DependencyNode effectiveNodeDependency = node;
        if (node.getData().containsKey("conflict.winner")) {
            effectiveNodeDependency = (DependencyNode)node.getData().get("conflict.winner");
        }
        if ((cachedValue = context.get(bundleDescriptor = BundleDependencyHelper.artifactToBundleDescriptor(artifact = effectiveNodeDependency.getArtifact()).build())) != null) {
            return cachedValue;
        }
        String scope = effectiveNodeDependency.getDependency().getScope();
        BundleScope bundleScope = StringUtils.isEmpty((CharSequence)scope) ? BundleScope.COMPILE : BundleScope.valueOf((String)scope.toUpperCase());
        BundleDependency.Builder bundleDependencyBuilder = BundleDependencyHelper.artifactToBundleDependency(effectiveNodeDependency.getArtifact(), bundleScope.name());
        Map<BundleDescriptor, BundleDependency> nextContext = this.getContext(effectiveNodeDependency, context);
        effectiveNodeDependency.getChildren().stream().filter(children -> transitiveDependencyFilter.accept(children, Collections.emptyList())).forEach(childNode -> bundleDependencyBuilder.addTransitiveDependency(this.getBundleDependency((DependencyNode)childNode, nextContext, transitiveDependencyFilter)));
        BundleDependency bundleDependency = bundleDependencyBuilder.build();
        context.put(bundleDependency.getDescriptor(), bundleDependency);
        return bundleDependencyBuilder.build();
    }

    static BundleDependency.Builder artifactToBundleDependency(Artifact artifact, String scope) {
        BundleDescriptor.Builder bundleDescriptorBuilder = BundleDependencyHelper.artifactToBundleDescriptor(artifact);
        BundleScope bundleScope = StringUtils.isEmpty((CharSequence)scope) ? BundleScope.COMPILE : BundleScope.valueOf((String)scope.toUpperCase());
        BundleDependency.Builder builder = new BundleDependency.Builder().setDescriptor(bundleDescriptorBuilder.build()).setScope(bundleScope);
        if (artifact.getFile() != null) {
            builder.setBundleUri(artifact.getFile().toURI());
        }
        return builder;
    }

    static BundleDescriptor.Builder artifactToBundleDescriptor(Artifact artifact) {
        BundleDescriptor.Builder bundleDescriptorBuilder = new BundleDescriptor.Builder().setArtifactId(artifact.getArtifactId()).setGroupId(artifact.getGroupId()).setVersion(artifact.getVersion()).setBaseVersion(artifact.getBaseVersion()).setType(artifact.getExtension());
        String classifier = artifact.getClassifier();
        if (!org.eclipse.aether.util.StringUtils.isEmpty((String)classifier)) {
            bundleDescriptorBuilder.setClassifier(classifier);
        }
        return bundleDescriptorBuilder;
    }

    private Map<BundleDescriptor, BundleDependency> getContext(DependencyNode node, Map<BundleDescriptor, BundleDependency> parentContext) {
        if ("mule-plugin".equals(node.getArtifact().getClassifier())) {
            String key = node.getArtifact().getGroupId() + ":" + node.getArtifact().getArtifactId();
            return this.contexts.computeIfAbsent(key, k -> new HashMap());
        }
        return parentContext;
    }
}

