/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.JavaDependencyContextRefiner;
import org.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import org.eclipse.aether.util.graph.transformer.JavaScopeSelector;
import org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import org.mule.maven.client.internal.AetherServiceRegister;
import org.mule.maven.client.internal.ApiDependencyGraphTransformer;
import org.mule.maven.client.internal.ArtifactRestorerTransformer;
import org.mule.maven.client.internal.DefaultModelResolver;
import org.mule.maven.client.internal.MuleDomainDependencyGraphTransformer;
import org.mule.maven.client.internal.MulePluginDependencyGraphTransformer;
import org.mule.maven.client.internal.MuleVersionSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherRepositoryState {
    private static final Logger LOGGER = LoggerFactory.getLogger(AetherRepositoryState.class);
    private DefaultServiceLocator locator;
    private DefaultRepositorySystemSession session;
    private RepositorySystem system;

    public AetherRepositoryState(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader, Optional<AuthenticationSelector> authenticationSelector, Optional<ProxySelector> proxySelector, Optional<MirrorSelector> mirrorSelector, boolean noSnapshotUpdates, boolean offline, boolean ignoreArtifactDescriptorRepositories, Optional<Properties> userProperties, Consumer<DefaultRepositorySystemSession> sessionConfigurator) {
        this(localRepositoryFolder, workspaceReader, authenticationSelector, proxySelector, mirrorSelector, noSnapshotUpdates, offline, ignoreArtifactDescriptorRepositories, userProperties, sessionConfigurator, false);
    }

    public AetherRepositoryState(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader, Optional<AuthenticationSelector> authenticationSelector, Optional<ProxySelector> proxySelector, Optional<MirrorSelector> mirrorSelector, boolean noSnapshotUpdates, boolean offline, boolean ignoreArtifactDescriptorRepositories, Optional<Properties> userProperties, Consumer<DefaultRepositorySystemSession> sessionConfigurator, boolean updateSnapshots) {
        this.createRepositorySession(localRepositoryFolder, workspaceReader, offline, ignoreArtifactDescriptorRepositories, authenticationSelector, proxySelector, mirrorSelector, noSnapshotUpdates, updateSnapshots, userProperties, sessionConfigurator);
    }

    private void createRepositorySession(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader, boolean offline, boolean ignoreArtifactDescriptorRepositories, Optional<AuthenticationSelector> authenticationSelector, Optional<ProxySelector> proxySelector, Optional<MirrorSelector> mirrorSelector, boolean noSnapshotUpdates, boolean updateSnapshots, Optional<Properties> userProperties, Consumer<DefaultRepositorySystemSession> sessionConfigurator) {
        this.session = AetherRepositoryState.newDefaultRepositorySystemSession(noSnapshotUpdates, updateSnapshots, sessionConfigurator);
        RepositorySystem repositorySystem = this.createRepositorySystem();
        this.session.setLocalRepositoryManager(repositorySystem.newLocalRepositoryManager((RepositorySystemSession)this.session, new LocalRepository(localRepositoryFolder)));
        this.session.setOffline(offline);
        this.session.setConfigProperty("aether.conflictResolver.verbose", (Object)true);
        proxySelector.ifPresent(arg_0 -> ((DefaultRepositorySystemSession)this.session).setProxySelector(arg_0));
        mirrorSelector.ifPresent(arg_0 -> ((DefaultRepositorySystemSession)this.session).setMirrorSelector(arg_0));
        authenticationSelector.ifPresent(arg_0 -> ((DefaultRepositorySystemSession)this.session).setAuthenticationSelector(arg_0));
        ConflictResolver transformer = new ConflictResolver((ConflictResolver.VersionSelector)new MuleVersionSelector(new NearestVersionSelector()), (ConflictResolver.ScopeSelector)new JavaScopeSelector(), (ConflictResolver.OptionalitySelector)new SimpleOptionalitySelector(), (ConflictResolver.ScopeDeriver)new JavaScopeDeriver());
        ArrayList<Object> graphTransformers = new ArrayList<Object>();
        graphTransformers.add(new MuleDomainDependencyGraphTransformer());
        graphTransformers.add(new ApiDependencyGraphTransformer());
        graphTransformers.add(new MulePluginDependencyGraphTransformer());
        graphTransformers.add(transformer);
        graphTransformers.add(new JavaDependencyContextRefiner());
        graphTransformers.add(new ArtifactRestorerTransformer());
        this.session.setDependencyGraphTransformer((DependencyGraphTransformer)new ChainedDependencyGraphTransformer(graphTransformers.toArray(new DependencyGraphTransformer[0])));
        this.session.setArtifactDescriptorPolicy((session, request) -> 0);
        this.session.setIgnoreArtifactDescriptorRepositories(ignoreArtifactDescriptorRepositories);
        workspaceReader.ifPresent(arg_0 -> ((DefaultRepositorySystemSession)this.session).setWorkspaceReader(arg_0));
        userProperties.ifPresent(properties -> this.session.setUserProperties((Map)properties));
        this.system = repositorySystem;
    }

    private RepositorySystem createRepositorySystem() {
        this.locator = new DefaultServiceLocator();
        this.locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        this.locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        this.locator.addService(RepositorySystem.class, DefaultRepositorySystem.class);
        this.locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        this.locator.addService(VersionResolver.class, DefaultVersionResolver.class);
        this.locator.addService(VersionRangeResolver.class, DefaultVersionRangeResolver.class);
        this.locator.addService(ArtifactDescriptorReader.class, DefaultArtifactDescriptorReader.class);
        this.locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                LOGGER.warn(exception.getMessage());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(exception.getMessage(), exception);
                }
            }
        });
        this.loadAetherServiceRegister().ifPresent(aetherServiceRegister -> aetherServiceRegister.registerServices(this.locator));
        return (RepositorySystem)this.locator.getService(RepositorySystem.class);
    }

    private Optional<AetherServiceRegister> loadAetherServiceRegister() {
        Iterator<AetherServiceRegister> iterator = ServiceLoader.load(AetherServiceRegister.class).iterator();
        if (iterator.hasNext()) {
            AetherServiceRegister serviceRegister = iterator.next();
            return Optional.of(serviceRegister);
        }
        return Optional.empty();
    }

    public DefaultRepositorySystemSession getSession() {
        return this.session;
    }

    public RepositorySystem getSystem() {
        return this.system;
    }

    public ModelResolver createModelResolver(List<RemoteRepository> repositories) {
        return new DefaultModelResolver(this.session, (ArtifactResolver)this.locator.getService(ArtifactResolver.class), (VersionRangeResolver)this.locator.getService(VersionRangeResolver.class), this.getRemoteRepositoryManager(), repositories);
    }

    private static DefaultRepositorySystemSession newDefaultRepositorySystemSession(boolean noUpdateSnapshots, boolean updateSnapshots, Consumer<DefaultRepositorySystemSession> sessionConfigurator) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(1));
        session.setCache((RepositoryCache)new DefaultRepositoryCache());
        if (noUpdateSnapshots) {
            session.setUpdatePolicy("never");
        } else if (updateSnapshots) {
            session.setUpdatePolicy("always");
        } else {
            session.setUpdatePolicy(null);
        }
        session.setChecksumPolicy("ignore");
        session.setTransferListener((TransferListener)new LoggingTransferListener());
        sessionConfigurator.accept(session);
        return session;
    }

    public void setWorkspaceReader(WorkspaceReader workspaceReader) {
        this.session.setWorkspaceReader(workspaceReader);
    }

    public RemoteRepositoryManager getRemoteRepositoryManager() {
        return (RemoteRepositoryManager)this.locator.getService(RemoteRepositoryManager.class);
    }

    private static final class LoggingTransferListener
    implements TransferListener {
        private LoggingTransferListener() {
        }

        public void transferSucceeded(TransferEvent event) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Transfer {} for '{}' from {}", new Object[]{event.getType(), event.getResource().getResourceName(), event.getResource().getRepositoryUrl()});
            }
        }

        public void transferStarted(TransferEvent event) throws TransferCancelledException {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Transfer {} for '{}'", (Object)event.getType(), (Object)event.getResource().getResourceName());
            }
        }

        public void transferProgressed(TransferEvent event) throws TransferCancelledException {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Transfer {} for '{}' ({}/{})", new Object[]{event.getType(), event.getResource().getResourceName(), FileUtils.byteCountToDisplaySize((long)event.getTransferredBytes()), FileUtils.byteCountToDisplaySize((long)event.getResource().getContentLength())});
            }
        }

        public void transferInitiated(TransferEvent event) throws TransferCancelledException {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Transfer {} for '{}'", (Object)event.getType(), (Object)event.getResource().getResourceName());
            }
        }

        public void transferFailed(TransferEvent event) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Transfer {} for '{}' ({})", new Object[]{event.getType(), event.getResource(), event.getException()});
            }
        }

        public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
            LOGGER.warn("Transfer {} for '{}' ({})", new Object[]{event.getType(), event.getResource(), event.getException()});
        }
    }
}

