/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.DependencyNode;
import org.mule.maven.client.internal.ApiDependencyGraphTransformer;
import org.mule.maven.client.internal.MulePluginDependencyGraphTransformer;

public class OneInstancePerNodeGraphTransformer
implements DependencyGraphTransformer {
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        this.rebuildIsolatedDependencies(node, Collections.newSetFromMap(new IdentityHashMap()));
        return node;
    }

    private void rebuildIsolatedDependencies(DependencyNode node, Set<DependencyNode> visited) {
        LinkedList<DependencyNode> newChildren = new LinkedList<DependencyNode>();
        if (visited.contains(node)) {
            return;
        }
        visited.add(node);
        for (DependencyNode child : node.getChildren()) {
            if (MulePluginDependencyGraphTransformer.isPlugin(child)) {
                newChildren.add(this.copy(child, new IdentityHashMap<DependencyNode, DependencyNode>(), d -> true));
                continue;
            }
            if (ApiDependencyGraphTransformer.isApi(child)) {
                newChildren.add(this.copy(child, new IdentityHashMap<DependencyNode, DependencyNode>(), ApiDependencyGraphTransformer::isApi));
                continue;
            }
            this.rebuildIsolatedDependencies(child, visited);
            newChildren.add(child);
        }
        node.setChildren(newChildren);
    }

    private DependencyNode copy(DependencyNode node, Map<DependencyNode, DependencyNode> visitedMapping, Predicate<DependencyNode> shouldCopy) {
        if (visitedMapping.containsKey(node)) {
            return visitedMapping.get(node);
        }
        DefaultDependencyNode newNode = new DefaultDependencyNode(node);
        visitedMapping.put(node, (DependencyNode)newNode);
        List children = node.getChildren().stream().map(n -> shouldCopy.test((DependencyNode)n) ? this.copy((DependencyNode)n, visitedMapping, shouldCopy) : n).collect(Collectors.toList());
        newNode.setChildren(children);
        return newNode;
    }
}

