/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal;

import static org.mule.maven.client.internal.AetherMavenClient.MULE_PLUGIN_CLASSIFIER;

import org.eclipse.aether.graph.DependencyNode;

/**
 *
 */
public class MulePluginDependencyGraphTransformer extends ParentContextDependencyGraphTransformer {

  public static final String PLUGIN_ANCESTOR_KEY = "plugin-ancestor";

  @Override
  protected boolean isSelectableParent(DependencyNode dependencyNode) {
    return isPlugin(dependencyNode);
  }

  @Override
  protected boolean isChildNode(DependencyNode childNode) {
    return !isPlugin(childNode);
  }

  @Override
  protected String getAncestorKey() {
    return PLUGIN_ANCESTOR_KEY;
  }

  /**
   * @return {@code true} if node is a {@code mule-plugin}.
   */
  private boolean isPlugin(DependencyNode node) {
    return node != null && node.getArtifact() != null && MULE_PLUGIN_CLASSIFIER.equals(node.getArtifact().getClassifier());
  }

}
