/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal.pom;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

import org.apache.maven.building.Source;
import org.apache.maven.building.UrlSource;
import org.apache.maven.model.building.ModelSource2;

/**
 * {@link ModelSource2} for a POM inside a JAR file.
 */
public class UrlModelSource implements ModelSource2 {

  private URL pomUrl;
  private Source pomSource;

  public UrlModelSource(URL pomUrl) {
    this.pomUrl = pomUrl;
    this.pomSource = new UrlSource(pomUrl);
  }

  @Override
  public ModelSource2 getRelatedSource(String relPath) {
    return null;
  }

  @Override
  public URI getLocationURI() {
    try {
      return pomUrl.toURI();
    } catch (URISyntaxException e) {
      throw new RuntimeException("pom has an invalid location URI");
    }
  }

  @Override
  public InputStream getInputStream() throws IOException {
    return pomSource.getInputStream();
  }

  @Override
  public String getLocation() {
    return pomSource.getLocation();
  }
}
