/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal;

import static java.lang.Boolean.TRUE;

import java.util.IdentityHashMap;
import java.util.Map;

import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.DependencyNode;

public abstract class GraphCycleAvoidingTransformer implements DependencyGraphTransformer {

  @Override
  public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) {
    Map<DependencyNode, Object> visitedNodes = new IdentityHashMap<>(512);
    visitGraph(node, visitedNodes);
    return node;
  }

  private void visitGraph(DependencyNode node, Map<DependencyNode, Object> visitedNodes) {
    if (!setVisited(node, visitedNodes)) {
      return;
    }

    transformNode(node);

    for (DependencyNode childNode : node.getChildren()) {
      visitGraph(childNode, visitedNodes);
    }
  }


  /**
   * Marks the specified node as being visited and determines whether the node has been visited before.
   *
   * @param node The node being visited, must not be {@code null}.
   * @return {@code true} if the node has not been visited before, {@code false} if the node was already visited.
   */
  private boolean setVisited(DependencyNode node, Map<DependencyNode, Object> visitedNodes) {
    return visitedNodes.put(node, TRUE) == null;
  }

  protected abstract void transformNode(DependencyNode node);

}
