/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal;

import org.eclipse.aether.impl.DefaultServiceLocator;

/**
 * Service provider interface to allow customers of MavenClient to inject different implementation of Maven services.
 *
 * @since 1.0
 */
public interface MuleMavenServiceRegister {

  /**
   * Allow to register/add services to Maven's {@link DefaultServiceLocator} used by MavenClient when resolving dependencies.
   *
   * @param serviceLocator Maven's {@link DefaultServiceLocator} in order to define service implementations.
   */
  void registerServices(DefaultServiceLocator serviceLocator);

}
