/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.JavaDependencyContextRefiner;
import org.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import org.eclipse.aether.util.graph.transformer.JavaScopeSelector;
import org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.ApiDependencyGraphTransformer;
import org.mule.maven.client.internal.ArtifactRestorerTransformer;
import org.mule.maven.client.internal.DefaultMuleMavenRepositoryState;
import org.mule.maven.client.internal.MuleDomainDependencyGraphTransformer;
import org.mule.maven.client.internal.MuleMavenConcurrentLocalRepository;
import org.mule.maven.client.internal.MuleMavenRepositoryState;
import org.mule.maven.client.internal.MuleMavenResolutionContext;
import org.mule.maven.client.internal.MulePluginDependencyGraphTransformer;
import org.mule.maven.client.internal.MuleVersionSelector;
import org.mule.maven.client.internal.OneInstancePerNodeGraphTransformer;
import org.mule.maven.client.internal.dependency.PluginAwareExclusionDependencySelector;
import org.mule.maven.client.internal.repository.MuleRepositorySystemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleMavenRepositoryStateFactory
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleMavenRepositoryStateFactory.class);
    public static final String MULE_MAVEN_CLIENT_CONCURRENT_LOCAL_REPOSITORY_PROPERTY = "mule.maven.client.concurrent.local.repository";
    private static final String LOCK_FACTORY_KEY = "aether.syncContext.named.factory";
    private static final String LOCK_NAME_MAPPER_KEY = "aether.syncContext.named.nameMapper";
    private final boolean isConcurrentLocalRepositoryEnabled = this.isConcurrentLocalRepositoryEnabled();
    private final MuleRepositorySystemManager muleRepositorySystemManager = MuleRepositorySystemManager.getManager();

    private boolean isConcurrentLocalRepositoryEnabled() {
        return Boolean.getBoolean(MULE_MAVEN_CLIENT_CONCURRENT_LOCAL_REPOSITORY_PROPERTY) || MuleMavenRepositoryStateFactory.loadConcurrentLocalRepository().map(MuleMavenConcurrentLocalRepository::isConcurrentLocalRepositoryEnabled).orElse(false) != false;
    }

    public MuleMavenRepositoryState createMavenRepositoryState(File localRepositoryLocation, MuleMavenResolutionContext muleMavenResolutionContext, MavenConfiguration mavenConfiguration, Optional<Consumer<DefaultRepositorySystemSession>> sessionConfigurator, Optional<WorkspaceReader> workspaceReader) {
        return this.createMavenRepositoryState(localRepositoryLocation, workspaceReader, muleMavenResolutionContext.getAuthenticatorSelector(), muleMavenResolutionContext.getProxySelector(), muleMavenResolutionContext.getMirrorSelector(), muleMavenResolutionContext.getServerConfigurations(), mavenConfiguration.getForcePolicyUpdateNever(), mavenConfiguration.getForcePolicyUpdateAlways(), mavenConfiguration.getOfflineMode(), mavenConfiguration.getIgnoreArtifactDescriptorRepositories(), (Optional<Properties>)mavenConfiguration.getUserProperties(), sessionConfigurator.orElse(session -> {}), mavenConfiguration.getGlobalChecksumPolicy());
    }

    public MuleMavenRepositoryState createMavenRepositoryState(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader, Optional<AuthenticationSelector> authenticationSelector, Optional<ProxySelector> proxySelector, Optional<MirrorSelector> mirrorSelector, Map<String, Object> serverConfigurations, boolean noSnapshotUpdates, boolean offline, boolean ignoreArtifactDescriptorRepositories, Optional<Properties> userProperties, Consumer<DefaultRepositorySystemSession> sessionConfigurator) {
        return this.createMavenRepositoryState(localRepositoryFolder, workspaceReader, offline, ignoreArtifactDescriptorRepositories, authenticationSelector, proxySelector, mirrorSelector, serverConfigurations, noSnapshotUpdates, false, userProperties, sessionConfigurator, null);
    }

    public MuleMavenRepositoryState createMavenRepositoryState(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader, Optional<AuthenticationSelector> authenticationSelector, Optional<ProxySelector> proxySelector, Optional<MirrorSelector> mirrorSelector, Map<String, Object> serverConfigurations, boolean noSnapshotUpdates, boolean updateSnapshots, boolean offline, boolean ignoreArtifactDescriptorRepositories, Optional<Properties> userProperties, Consumer<DefaultRepositorySystemSession> sessionConfigurator, String globalChecksumPolicy) {
        return this.createMavenRepositoryState(localRepositoryFolder, workspaceReader, offline, ignoreArtifactDescriptorRepositories, authenticationSelector, proxySelector, mirrorSelector, serverConfigurations, noSnapshotUpdates, updateSnapshots, userProperties, sessionConfigurator, globalChecksumPolicy);
    }

    public MuleMavenRepositoryState createMavenRepositoryState(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader, Optional<AuthenticationSelector> authenticationSelector, Optional<ProxySelector> proxySelector, Optional<MirrorSelector> mirrorSelector, boolean noSnapshotUpdates, boolean updateSnapshots, boolean offline, boolean ignoreArtifactDescriptorRepositories, Optional<Properties> userProperties, Consumer<DefaultRepositorySystemSession> sessionConfigurator, String globalChecksumPolicy) {
        return this.createMavenRepositoryState(localRepositoryFolder, workspaceReader, offline, ignoreArtifactDescriptorRepositories, authenticationSelector, proxySelector, mirrorSelector, Collections.emptyMap(), noSnapshotUpdates, updateSnapshots, userProperties, sessionConfigurator, globalChecksumPolicy);
    }

    private MuleMavenRepositoryState createMavenRepositoryState(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader, boolean offline, boolean ignoreArtifactDescriptorRepositories, Optional<AuthenticationSelector> authenticationSelector, Optional<ProxySelector> proxySelector, Optional<MirrorSelector> mirrorSelector, Map<String, Object> serverConfigurations, boolean noSnapshotUpdates, boolean updateSnapshots, Optional<Properties> userProperties, Consumer<DefaultRepositorySystemSession> sessionConfigurator, String globalChecksumPolicy) {
        DefaultRepositorySystemSession repositorySystemSession = MuleMavenRepositoryStateFactory.newDefaultRepositorySystemSession(noSnapshotUpdates, updateSnapshots, sessionConfigurator, globalChecksumPolicy, serverConfigurations);
        RepositorySystem repositorySystem = this.muleRepositorySystemManager.getRepositorySystem();
        repositorySystemSession.setSystemProperties((Map)System.getProperties());
        repositorySystemSession.setLocalRepositoryManager(repositorySystem.newLocalRepositoryManager((RepositorySystemSession)repositorySystemSession, new LocalRepository(localRepositoryFolder)));
        repositorySystemSession.setOffline(offline);
        repositorySystemSession.setConfigProperty("aether.conflictResolver.verbose", (Object)true);
        proxySelector.ifPresent(arg_0 -> ((DefaultRepositorySystemSession)repositorySystemSession).setProxySelector(arg_0));
        mirrorSelector.ifPresent(arg_0 -> ((DefaultRepositorySystemSession)repositorySystemSession).setMirrorSelector(arg_0));
        authenticationSelector.ifPresent(arg_0 -> ((DefaultRepositorySystemSession)repositorySystemSession).setAuthenticationSelector(arg_0));
        ConflictResolver transformer = new ConflictResolver((ConflictResolver.VersionSelector)new MuleVersionSelector(new NearestVersionSelector()), (ConflictResolver.ScopeSelector)new JavaScopeSelector(), (ConflictResolver.OptionalitySelector)new SimpleOptionalitySelector(), (ConflictResolver.ScopeDeriver)new JavaScopeDeriver());
        ArrayList<Object> graphTransformers = new ArrayList<Object>();
        graphTransformers.add(new OneInstancePerNodeGraphTransformer());
        graphTransformers.add(new MuleDomainDependencyGraphTransformer());
        graphTransformers.add(new ApiDependencyGraphTransformer());
        graphTransformers.add(new MulePluginDependencyGraphTransformer());
        graphTransformers.add(transformer);
        graphTransformers.add(new JavaDependencyContextRefiner());
        graphTransformers.add(new ArtifactRestorerTransformer());
        repositorySystemSession.setDependencyGraphTransformer((DependencyGraphTransformer)new ChainedDependencyGraphTransformer(graphTransformers.toArray(new DependencyGraphTransformer[0])));
        AndDependencySelector dependencySelector = new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"test", "provided"}), new OptionalDependencySelector(), new PluginAwareExclusionDependencySelector((DependencySelector)new ExclusionDependencySelector())});
        repositorySystemSession.setDependencySelector((DependencySelector)dependencySelector);
        repositorySystemSession.setArtifactDescriptorPolicy((session, request) -> 0);
        repositorySystemSession.setIgnoreArtifactDescriptorRepositories(ignoreArtifactDescriptorRepositories);
        workspaceReader.ifPresent(arg_0 -> ((DefaultRepositorySystemSession)repositorySystemSession).setWorkspaceReader(arg_0));
        userProperties.ifPresent(arg_0 -> ((DefaultRepositorySystemSession)repositorySystemSession).setUserProperties(arg_0));
        if (this.isConcurrentLocalRepositoryEnabled) {
            repositorySystemSession.setConfigProperty(LOCK_FACTORY_KEY, (Object)"file-lock");
            repositorySystemSession.setConfigProperty(LOCK_NAME_MAPPER_KEY, (Object)"file-gav");
        }
        return new DefaultMuleMavenRepositoryState(repositorySystemSession, repositorySystem, this.muleRepositorySystemManager.getArtifactResolver(), this.muleRepositorySystemManager.getVersionRangeResolver(), this.muleRepositorySystemManager.getRemoteRepositoryManager());
    }

    private static DefaultRepositorySystemSession newDefaultRepositorySystemSession(boolean noUpdateSnapshots, boolean updateSnapshots, Consumer<DefaultRepositorySystemSession> sessionConfigurator, String globalChecksumPolicy, Map<String, Object> serverConfigurations) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(1));
        session.setCache((RepositoryCache)new DefaultRepositoryCache());
        if (noUpdateSnapshots) {
            session.setUpdatePolicy("never");
        } else if (updateSnapshots) {
            session.setUpdatePolicy("always");
        } else {
            session.setUpdatePolicy(null);
        }
        if (globalChecksumPolicy != null) {
            session.setChecksumPolicy(globalChecksumPolicy);
        }
        session.setTransferListener((TransferListener)new LoggingTransferListener());
        session.setConfigProperties(serverConfigurations);
        sessionConfigurator.accept(session);
        return session;
    }

    @Override
    public void close() throws Exception {
        this.muleRepositorySystemManager.close();
    }

    private static Optional<MuleMavenConcurrentLocalRepository> loadConcurrentLocalRepository() {
        Iterator<MuleMavenConcurrentLocalRepository> iterator = ServiceLoader.load(MuleMavenConcurrentLocalRepository.class, MuleMavenRepositoryStateFactory.class.getClassLoader()).iterator();
        if (iterator.hasNext()) {
            MuleMavenConcurrentLocalRepository serviceRegister = iterator.next();
            return Optional.of(serviceRegister);
        }
        return Optional.empty();
    }

    private static final class LoggingTransferListener
    implements TransferListener {
        private LoggingTransferListener() {
        }

        public void transferSucceeded(TransferEvent event) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Transfer {} for '{}' from {}", new Object[]{event.getType(), event.getResource().getResourceName(), event.getResource().getRepositoryUrl()});
            }
        }

        public void transferStarted(TransferEvent event) throws TransferCancelledException {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Transfer {} for '{}'", (Object)event.getType(), (Object)event.getResource().getResourceName());
            }
        }

        public void transferProgressed(TransferEvent event) throws TransferCancelledException {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Transfer {} for '{}' ({}/{})", new Object[]{event.getType(), event.getResource().getResourceName(), FileUtils.byteCountToDisplaySize((long)event.getTransferredBytes()), FileUtils.byteCountToDisplaySize((long)event.getResource().getContentLength())});
            }
        }

        public void transferInitiated(TransferEvent event) throws TransferCancelledException {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Transfer {} for '{}'", (Object)event.getType(), (Object)event.getResource().getResourceName());
            }
        }

        public void transferFailed(TransferEvent event) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Transfer {} for '{}' ({})", new Object[]{event.getType(), event.getResource(), event.getException()});
            }
        }

        public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
            LOGGER.warn("Transfer {} for '{}' ({})", new Object[]{event.getType(), event.getResource(), event.getException()});
        }
    }
}

