/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal.util;

import static com.vdurmont.semver4j.Semver.SemverType.LOOSE;
import static java.lang.String.format;

import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;

public class VersionChecker {

  public static boolean areCompatibleVersions(String version1, String version2) {
    return getSemver(version1).getMajor().equals(getSemver(version2).getMajor());
  }

  public static String getHighestVersion(String version1, String version2) {
    final Semver semver1 = new Semver(version1, LOOSE);
    final Semver semver2 = new Semver(version2, LOOSE);
    return semver1.isGreaterThan(semver2) ? semver1.getOriginalValue() : semver2.getOriginalValue();
  }

  public static boolean isHighestVersion(String version1, String version2) {
    final Semver semver1 = new Semver(version1, LOOSE);
    final Semver semver2 = new Semver(version2, LOOSE);
    return semver1.isGreaterThan(semver2);
  }

  private static Semver getSemver(String version) {
    try {
      return new Semver(version, LOOSE);
    } catch (SemverException e) {
      throw new IllegalArgumentException(
                                         format("Unable to parse version %s, version is not following semantic versioning",
                                                version),
                                         e);
    }
  }

}
