/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal;

import static java.util.Arrays.asList;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.aether.graph.DependencyNode;

public class ApiDependencyGraphTransformer extends ParentContextDependencyGraphTransformer {

  private static final Set<String> API_CLASSIFIERS = new HashSet<>(asList("raml", "oas", "raml-fragment", "wsdl"));
  private static final String API_ANCESTOR_KEY = "api-ancestor";

  @Override
  protected boolean isSelectableParent(DependencyNode dependencyNode) {
    return isApi(dependencyNode);
  }

  @Override
  protected boolean isChildNode(DependencyNode childNode) {
    return isApi(childNode);
  }

  @Override
  protected String getAncestorKey() {
    return API_ANCESTOR_KEY;
  }

  public static boolean isApi(DependencyNode node) {
    return node.getArtifact() != null && API_CLASSIFIERS.contains(node.getArtifact().getClassifier());
  }
}
