/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal;

import static java.util.Collections.emptyList;
import static java.util.stream.Collectors.toList;
import org.mule.maven.client.api.VersionRangeResult;

import java.util.List;

/**
 * Default implementation for {@link VersionRangeResult}.
 *
 * @since 1.1
 */
public class DefaultVersionRangeResult implements VersionRangeResult {

  private List<String> versions = emptyList();

  public DefaultVersionRangeResult(org.eclipse.aether.resolution.VersionRangeResult aetherVersionRangeResult) {
    this.versions = aetherVersionRangeResult.getVersions().stream()
        .map(aetherVersion -> aetherVersion.toString())
        .collect(toList());
  }

  @Override
  public List<String> getVersions() {
    return versions;
  }

  @Override
  public String getLowestVersion() {
    if (versions.isEmpty()) {
      return null;
    }
    return versions.get(0);
  }

  @Override
  public String getHighestVersion() {
    if (versions.isEmpty()) {
      return null;
    }
    return versions.get(versions.size() - 1);
  }

}
