/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal.version;

import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;

public class MavenVersion {

  private final Version version;

  public MavenVersion(String version) throws InvalidVersionSpecificationException {
    this.version = new GenericVersionScheme().parseVersion(version);
  }

  protected Version getVersion() {
    return version;
  }
}
