/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal;

import java.util.List;

import org.apache.maven.model.resolution.ModelResolver;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

/**
 * Holds the state for Maven's repository state for the resolution of dependencies of a particular artifact.
 */
public interface MuleMavenRepositoryState {

  /**
   * @return the Maven session.
   */
  DefaultRepositorySystemSession getSession();

  /**
   * @return Maven's repository system.
   */
  RepositorySystem getSystem();

  /**
   * @param repositories remote repositories where to look for artifacts.
   * @return a {@link ModelResolver}.
   */
  ModelResolver createModelResolver(List<RemoteRepository> repositories);

  /**
   * @return Maven's remote repository manager.
   */
  RemoteRepositoryManager getRemoteRepositoryManager();

}
