/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.test;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.maven.client.internal.DefaultLocalRepositorySupplierFactory;
import org.mule.maven.client.internal.DefaultSettingsSupplierFactory;
import org.mule.maven.client.internal.MavenEnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenTestHelper {
    private static final String MULESOFT_PUBLIC_REPOSITORY = "https://repository.mulesoft.org/nexus/content/repositories/public/";
    private static final String MULESOFT_PRIVATE_REPOSITORY = "https://repository.mulesoft.org/nexus/content/repositories/private/";
    private static Logger LOGGER = LoggerFactory.getLogger(MavenTestHelper.class);

    public static MavenConfiguration createDefaultEnterpriseMavenConfiguration() throws IOException {
        return MavenTestHelper.createDefaultEnterpriseMavenConfiguration(false);
    }

    public static MavenConfiguration createDefaultEnterpriseMavenConfiguration(boolean forceUpdateSnapshots) throws IOException {
        MavenConfiguration mavenConfiguration = MavenTestHelper.createDefaultEnterpriseMavenConfigurationBuilder(forceUpdateSnapshots).build();
        LOGGER.info("Using MavenConfiguration {}", (Object)mavenConfiguration);
        return mavenConfiguration;
    }

    public static MavenConfiguration createDefaultCommunityMavenConfiguration(boolean forceUpdateSnapshots) throws IOException {
        MavenConfiguration mavenConfiguration = MavenTestHelper.createDefaultCommunityMavenConfigurationBuilder(forceUpdateSnapshots).build();
        LOGGER.info("Using MavenConfiguration {}", (Object)mavenConfiguration);
        return mavenConfiguration;
    }

    public static MavenConfiguration createDefaultCommunityMavenConfiguration() throws IOException {
        return MavenTestHelper.createDefaultCommunityMavenConfiguration(false);
    }

    public static MavenConfiguration.MavenConfigurationBuilder createDefaultEnterpriseMavenConfigurationBuilder() throws IOException {
        return MavenTestHelper.createDefaultMavenConfigurationBuilder(true, false);
    }

    public static MavenConfiguration.MavenConfigurationBuilder createDefaultEnterpriseMavenConfigurationBuilder(boolean forceUpdateSnapshots) throws IOException {
        return MavenTestHelper.createDefaultMavenConfigurationBuilder(true, forceUpdateSnapshots);
    }

    public static MavenConfiguration.MavenConfigurationBuilder createDefaultCommunityMavenConfigurationBuilder() throws IOException {
        return MavenTestHelper.createDefaultMavenConfigurationBuilder(false, false);
    }

    public static MavenConfiguration.MavenConfigurationBuilder createDefaultCommunityMavenConfigurationBuilder(boolean forceUpdateSnapshots) throws IOException {
        return MavenTestHelper.createDefaultMavenConfigurationBuilder(false, forceUpdateSnapshots);
    }

    public static File getLocalRepositoryFolder() {
        return (File)new DefaultLocalRepositorySupplierFactory().environmentMavenRepositorySupplier().get();
    }

    private static MavenConfiguration.MavenConfigurationBuilder createDefaultMavenConfigurationBuilder(boolean enterprise, boolean forceUpdateSnapshots) throws IOException {
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder().forcePolicyUpdateNever(!forceUpdateSnapshots);
        File localMavenRepository = MavenTestHelper.getLocalRepositoryFolder();
        mavenConfigurationBuilder.localMavenRepositoryLocation(localMavenRepository);
        DefaultSettingsSupplierFactory settingsSupplierFactory = new DefaultSettingsSupplierFactory(new MavenEnvironmentVariables());
        mavenConfigurationBuilder.remoteRepository(RemoteRepository.newRemoteRepositoryBuilder().id("mulesoft-public").url(new URL(MULESOFT_PUBLIC_REPOSITORY)).build());
        if (enterprise) {
            mavenConfigurationBuilder.remoteRepository(RemoteRepository.newRemoteRepositoryBuilder().id("mulesoft-private").url(new URL(MULESOFT_PRIVATE_REPOSITORY)).build());
        }
        settingsSupplierFactory.environmentUserSettingsSupplier().ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).userSettingsLocation(arg_0));
        settingsSupplierFactory.environmentGlobalSettingsSupplier().ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).globalSettingsLocation(arg_0));
        return mavenConfigurationBuilder;
    }
}

