/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.test;

import static org.junit.rules.ExpectedException.none;
import static org.mule.maven.client.api.MavenClientProvider.discoverProvider;
import static org.mule.maven.client.test.AllureConstants.MavenClient.MAVEN_CLIENT;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import io.qameta.allure.Feature;

@Feature(MAVEN_CLIENT)
public abstract class AbstractMavenClientTestCase {

  protected MavenClient mavenClient;
  protected MavenClientProvider mavenClientProvider;

  @ClassRule
  public static TemporaryFolder repositoryFolder = new TemporaryFolder();
  @Rule
  public ExpectedException expectedException = none();

  @Before
  public void setUp() throws Exception {
    mavenClientProvider = discoverProvider(getClass().getClassLoader());
    beforeTest();
  }

  protected abstract void beforeTest() throws Exception;

}
