/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.test;

import static org.apache.commons.io.FileUtils.toFile;
import static org.mule.maven.client.api.model.MavenConfiguration.newMavenConfigurationBuilder;
import static org.mule.maven.client.test.AllureConstants.MavenClient.OnlineWithSettingsStory.ONLINE_STORY;
import org.mule.maven.client.api.model.MavenConfiguration;

import java.net.MalformedURLException;
import java.net.URL;

import io.qameta.allure.Story;

@Story(ONLINE_STORY)
public class OnlineWithMavenSettingsTestCase extends AbstractOnlineMavenClientTestCase {

  @Override
  protected MavenConfiguration createMavenConfiguration() throws MalformedURLException {
    URL settingsUrl = getClass().getClassLoader().getResource("custom-settings.xml");
    return newMavenConfigurationBuilder().localMavenRepositoryLocation(repositoryFolder.getRoot())
        .globalSettingsLocation(toFile(settingsUrl)).build();
  }


}
