/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.test;

import static org.apache.commons.io.FileUtils.toFile;
import static org.hamcrest.CoreMatchers.containsString;
import static org.hamcrest.CoreMatchers.instanceOf;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.fail;
import static org.mule.maven.client.api.model.MavenConfiguration.newMavenConfigurationBuilder;
import static org.mule.maven.client.api.model.RemoteRepository.newRemoteRepositoryBuilder;
import static org.mule.maven.client.test.AllureConstants.MavenClient.ProxyStory.PROXY_STORY;
import org.mule.maven.client.api.BundleDependenciesResolutionException;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;

import java.io.File;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;

import io.qameta.allure.Story;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.Test;

@Story(PROXY_STORY)
public class ProxyTestCase extends AbstractMavenClientTestCase {

  private String groupId = "org.mule";
  private String artifactId = "mule-core";
  private String version = "3.3.0";
  private String type = "jar";

  @Override
  protected void beforeTest() throws Exception {}

  private MavenConfiguration createMavenConfiguration(File userSettingsLocation, RemoteRepository remoteRepository)
      throws MalformedURLException {
    return newMavenConfigurationBuilder()
        .localMavenRepositoryLocation(repositoryFolder.getRoot())
        .remoteRepository(remoteRepository)
        .userSettingsLocation(userSettingsLocation)
        .build();
  }

  @Test
  public void useProxy() throws MalformedURLException {
    final RemoteRepository remoteRepository = newRemoteRepositoryBuilder()
        .id("mulesoft-public")
        .url(new URL("https://repository.mulesoft.org/nexus/content/repositories/public/"))
        .build();

    URL settingsUrl = getClass().getClassLoader().getResource("settings-with-proxy.xml");
    mavenClient = mavenClientProvider.createMavenClient(createMavenConfiguration(toFile(settingsUrl), remoteRepository));

    try {
      mavenClient.resolveBundleDescriptor(new BundleDescriptor.Builder().setGroupId(groupId)
          .setArtifactId(artifactId)
          .setVersion(version)
          .setType(type).build());
      fail();
    } catch (BundleDependenciesResolutionException e) {
      assertThat(e.getMessage(), containsString("Connection to http://proxy.testing.com:8080 refused"));
      final Throwable rootCause = ExceptionUtils.getRootCause(e);
      assertThat(rootCause, instanceOf(ConnectException.class));
    }
  }

}
