/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.test;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.function.Supplier;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;

public final class MavenTestUtils {
    private static final String POM_XML = "pom.xml";

    private MavenTestUtils() {
    }

    public static String getMavenProperty(String property, Supplier<File> pomFolderFinder) {
        String propertyValue = System.getProperty(property);
        if (propertyValue != null) {
            return propertyValue;
        }
        Model mavenProject = MavenTestUtils.mavenProject(pomFolderFinder);
        propertyValue = (String)mavenProject.getProperties().get(property);
        return MavenTestUtils.resolveMavenProperty(propertyValue, mavenProject);
    }

    public static String getMavenProjectVersion(Supplier<File> pomFolderFinder) {
        Model mavenProject = MavenTestUtils.mavenProject(pomFolderFinder);
        String muleVersion = MavenTestUtils.resolveMavenProperty(mavenProject.getVersion(), mavenProject);
        if (muleVersion != null) {
            return muleVersion;
        }
        return mavenProject.getParent().getVersion();
    }

    public static Supplier<File> mavenPomFinder(Class clazz) {
        return () -> {
            try {
                return new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getParentFile().getParentFile();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        };
    }

    private static Model mavenProject(Supplier<File> pomFolderFinder) {
        return MavenTestUtils.createMavenProject(new File(pomFolderFinder.get(), POM_XML));
    }

    private static String resolveMavenProperty(String propertyValue, Model mavenProject) {
        if (propertyValue != null && propertyValue.startsWith("${") && propertyValue.endsWith("}")) {
            String property = propertyValue.substring(propertyValue.indexOf("{") + 1, propertyValue.lastIndexOf("}"));
            return mavenProject.getProperties().get(property).toString();
        }
        return propertyValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Model createMavenProject(File pomFile) {
        MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        if (pomFile == null) throw new IllegalArgumentException("pom file doesn't exits for path: " + pomFile);
        if (!pomFile.exists()) throw new IllegalArgumentException("pom file doesn't exits for path: " + pomFile);
        try (FileReader reader = new FileReader(pomFile);){
            Model model = mavenReader.read((Reader)reader);
            model.setPomFile(pomFile);
            Model model2 = model;
            return model2;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't get Maven Artifact from pom: " + pomFile, e);
        }
    }
}

