/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.test;

import static org.mule.maven.client.api.model.MavenConfiguration.newMavenConfigurationBuilder;
import static org.mule.maven.client.api.model.RemoteRepository.newRemoteRepositoryBuilder;
import static org.mule.maven.client.test.AllureConstants.MavenClient.OnlineWithReposStory.ONLINE_STORY;
import org.mule.maven.client.api.model.MavenConfiguration;

import java.net.MalformedURLException;
import java.net.URL;

import io.qameta.allure.Story;

@Story(ONLINE_STORY)
public class OnlineWithRepositoriesTestCase extends AbstractOnlineMavenClientTestCase {

  @Override
  protected MavenConfiguration createMavenConfiguration() throws MalformedURLException {
    return newMavenConfigurationBuilder()
        .localMavenRepositoryLocation(repositoryFolder.getRoot())
        .remoteRepository(newRemoteRepositoryBuilder()
            .id("maven-central")
            .url(new URL("https://repo.maven.apache.org/maven2/")).build())
        .remoteRepository(newRemoteRepositoryBuilder()
            .id("mulesoft-public")
            .url(new URL("https://repository.mulesoft.org/nexus/content/repositories/public/")).build())
        .build();
  }
}
