/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.test;

import static org.apache.commons.io.FileUtils.toFile;
import static org.hamcrest.CoreMatchers.notNullValue;
import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;
import static org.mule.maven.client.api.model.MavenConfiguration.newMavenConfigurationBuilder;
import static org.mule.maven.client.api.model.RemoteRepository.newRemoteRepositoryBuilder;
import static org.mule.maven.client.test.AllureConstants.MavenClient.MirrorStory.MIRROR_STORY;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import io.qameta.allure.Story;
import org.junit.Test;

@Story(MIRROR_STORY)
public class MirrorTestCase extends AbstractMavenClientTestCase {

  private String groupId = "org.mule";
  private String artifactId = "mule-core";
  private String version = "3.3.0";
  private String type = "jar";

  @Override
  protected void beforeTest() throws Exception {}

  private MavenConfiguration createMavenConfiguration(File userSettingsLocation, RemoteRepository remoteRepository)
      throws MalformedURLException {
    return newMavenConfigurationBuilder()
        .localMavenRepositoryLocation(repositoryFolder.getRoot())
        .remoteRepository(remoteRepository)
        .userSettingsLocation(userSettingsLocation)
        .build();
  }

  @Test
  public void useMirror() throws MalformedURLException {
    final RemoteRepository remoteRepository = newRemoteRepositoryBuilder()
        .id("codehaus")
        .url(new URL("http://codehaus.com"))
        .build();

    URL settingsUrl = getClass().getClassLoader().getResource("settings-with-mirror.xml");
    mavenClient = mavenClientProvider.createMavenClient(createMavenConfiguration(toFile(settingsUrl), remoteRepository));

    final BundleDependency bundleDependency =
        mavenClient.resolveBundleDescriptor(new BundleDescriptor.Builder().setGroupId(groupId)
            .setArtifactId(artifactId)
            .setVersion(version)
            .setType(type).build());

    assertThat(bundleDependency, notNullValue());
    assertThat(bundleDependency.getDescriptor().getArtifactId(), equalTo(artifactId));
  }

}
