/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.test;

import static java.util.Optional.empty;
import static org.apache.commons.io.FileUtils.toFile;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static org.hamcrest.core.IsNot.not;
import static org.mule.maven.client.api.model.MavenConfiguration.newMavenConfigurationBuilder;
import static org.mule.maven.client.test.AllureConstants.MavenClient.MAVEN_CLIENT;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.MavenConfiguration;

import java.io.File;
import java.io.IOException;
import java.util.List;

import io.qameta.allure.Story;
import org.junit.Test;

@Story(MAVEN_CLIENT)
public class SystemScopeDependencyTestCase extends AbstractMavenClientTestCase {

  @Override
  protected void beforeTest() {}

  private MavenConfiguration createMavenConfiguration(File localRepository) {
    return newMavenConfigurationBuilder()
        .localMavenRepositoryLocation(localRepository)
        .ignoreArtifactDescriptorRepositories(false)
        .build();
  }

  @Test
  public void systemScopeDependencyRelativePathToJavaHome() throws IOException {
    doTestWith("pom-with-system-dependency/pom.xml", true);
  }

  private void doTestWith(String pomResourceFile, boolean includeTestDependencies) throws IOException {
    mavenClient = mavenClientProvider.createMavenClient(createMavenConfiguration(temporaryFolder.newFolder()));
    File artifactFile = toFile(getClass().getClassLoader().getResource(pomResourceFile));
    List<BundleDependency> bundleDependencies =
        mavenClient.resolveArtifactDependencies(artifactFile, includeTestDependencies, false, empty(), empty());

    assertThat(bundleDependencies, hasSize(1));
    BundleDependency bundleDependency = bundleDependencies.get(0);
    assertThat(bundleDependency.getBundleUri(), not(nullValue()));
    BundleDescriptor bundleDescriptor = bundleDependency.getDescriptor();
    assertThat(bundleDescriptor.getArtifactId(), equalTo("tools"));
  }

}
