/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.test;

import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;
import static org.apache.commons.io.FileUtils.toFile;
import static org.hamcrest.collection.IsIterableContainingInOrder.contains;
import static org.junit.Assert.assertThat;
import static org.mule.maven.client.api.model.MavenConfiguration.newMavenConfigurationBuilder;
import static org.mule.maven.client.api.model.RemoteRepository.newRemoteRepositoryBuilder;
import static org.mule.maven.client.test.AllureConstants.MavenClient.OnlineWithReposStory.ONLINE_STORY;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.MavenConfiguration;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

import io.qameta.allure.Story;
import org.junit.Test;

@Story(ONLINE_STORY)
public class OnlineWithRepositoriesTestCase extends AbstractOnlineMavenClientTestCase {

  @Override
  protected MavenConfiguration createMavenConfiguration() throws MalformedURLException {
    return newMavenConfigurationBuilder()
        .localMavenRepositoryLocation(repositoryFolder.getRoot())
        .remoteRepository(newRemoteRepositoryBuilder()
            .id("maven-central")
            .url(new URL("https://repo.maven.apache.org/maven2/")).build())
        .remoteRepository(newRemoteRepositoryBuilder()
            .id("mulesoft-public")
            .url(new URL("https://repository.mulesoft.org/nexus/content/repositories/public/")).build())
        .build();
  }

  @Test
  public void resolveArtifactDependenciesFromPomFileInsideJar() throws MalformedURLException {
    BundleDependency bundleDependency = mavenClient.resolveBundleDescriptor(new BundleDescriptor.Builder()
        .setGroupId("org.mule.connectors")
        .setArtifactId("mule-sockets-connector")
        .setVersion("1.1.1")
        .setType("jar")
        .setClassifier("mule-plugin")
        .build());
    List<BundleDependency> bundleDependencies =
        mavenClient.resolveArtifactDependencies(toFile(bundleDependency.getBundleUri().toURL()),
                                                false,
                                                false,
                                                of(repositoryFolder.getRoot()),
                                                of(temporaryFolder.getRoot()));

    List<String> result = bundleDependencies.stream().map(dep -> dep.getDescriptor().getArtifactId()).collect(toList());
    assertThat(result, contains("commons-io", "guava", "jsr305", "checker-qual", "error_prone_annotations", "j2objc-annotations",
                                "animal-sniffer-annotations"));
  }


}
