/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.test;

import static org.junit.rules.ExpectedException.none;
import static org.mule.maven.client.api.MavenClientProvider.discoverProvider;
import static org.mule.maven.client.test.AllureConstants.MavenClient.MAVEN_CLIENT;

import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.maven.test.ArtifactCreator;
import org.mule.maven.test.MavenRepository;

import io.qameta.allure.Feature;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

@Feature(MAVEN_CLIENT)
public abstract class AbstractMavenClientTestCase {

  protected static final String VERSION = "1.0";
  protected static final String GROUP_ID = "org.mule";
  protected static final String MULE_PLUGIN = AetherMavenClient.MULE_PLUGIN_CLASSIFIER;
  protected static final String RAML = "raml";
  protected static final String RAML_FRAGMENT = "raml-fragment";
  protected static final String OAS = "oas";
  protected static final String WSDL = "wsdl";

  protected MavenClient mavenClient;
  protected MavenClientProvider mavenClientProvider;

  @Rule
  public MavenRepository repositoryFolder = new MavenRepository();
  @Rule
  public ExpectedException expectedException = none();
  @Rule
  public TemporaryFolder temporaryFolder = new TemporaryFolder();

  @Before
  public void setUp() throws Exception {
    mavenClientProvider = discoverProvider(getClass().getClassLoader());
    beforeTest();
  }

  protected abstract void beforeTest() throws Exception;


  protected ArtifactCreator.Builder<ArtifactCreator.Builder> artifact(String artifactId) {
    return ArtifactCreator.artifact(GROUP_ID, artifactId, VERSION);
  }

  protected ArtifactCreator.DependencyBuilder dependency(String artifactId) {
    return ArtifactCreator.dependency(GROUP_ID, artifactId, VERSION);
  }

  protected ArtifactCreator.ExclusionBuilder exclusion(String artifactId) {
    return ArtifactCreator.exclusion(GROUP_ID, artifactId);
  }

  protected BundleDescriptor getDescriptor(String artifactId) {
    return getDescriptor(artifactId, VERSION);
  }

  protected BundleDescriptor getDescriptor(String artifactId, String version) {
    return getDescriptor(artifactId, version, "pom");
  }

  protected BundleDescriptor getDescriptor(String artifactId, String version, String type) {
    return getDescriptor(artifactId, version, type, null);
  }

  protected BundleDescriptor getDescriptor(String artifactId, String version, String type, String classifier) {
    BundleDescriptor.Builder builder = new BundleDescriptor.Builder()
        .setGroupId(GROUP_ID)
        .setArtifactId(artifactId)
        .setVersion(version)
        .setType(type);
    if (classifier != null) {
      builder.setClassifier(classifier);
    }
    return builder.build();
  }
}
