/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.test;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.collection.IsIterableContainingInOrder.contains;
import static org.junit.Assert.assertThat;
import static org.mule.maven.client.test.dependency.BundleDependencyMatcher.BundleDependencyMatcherBuilder.withArtifactId;
import static org.mule.maven.client.test.dependency.BundleDependencyMatcher.aBundleDependency;

import org.mule.maven.client.api.model.BundleDependency;

import java.util.List;

import org.junit.Test;

public class MuleMavenArtifactsDependenciesTestCase extends OnlineWithRepositoriesTestCase {

  private static final String APP = "app";

  @Test
  public void pluginsAsTransitiveLibDependencies() {
    //Since version 1.1.0 of plugin should win, it should appear in the final list, with all it's transitive dependencies.
    //Also, it should hang as transitive from the lib-aa dep by replacing it's original.
    repositoryFolder.addArtifacts(
                                  artifact(APP).dependencies(
                                                             dependency("lib-a").dependencies(
                                                                                              dependency("lib-aa").dependencies(
                                                                                                                                dependency("plugin")
                                                                                                                                    .classifier(MULE_PLUGIN)
                                                                                                                                    .version("1.0.0")
                                                                                                                                    .dependencies(
                                                                                                                                                  dependency("plugin-shared-dep")
                                                                                                                                                      .version("2.0.0"),
                                                                                                                                                  dependency("plugin-1-dep")))),
                                                             dependency("lib-b").dependencies(
                                                                                              dependency("lib-bb").dependencies(
                                                                                                                                dependency("plugin")
                                                                                                                                    .classifier(MULE_PLUGIN)
                                                                                                                                    .version("1.1.0")
                                                                                                                                    .dependencies(
                                                                                                                                                  dependency("plugin-shared-dep")
                                                                                                                                                      .version("1.0.0"),
                                                                                                                                                  dependency("plugin-2-dep")))))
                                      .build());
    List<BundleDependency> bundleDependencies = mavenClient.resolveBundleDescriptorDependencies(false, getDescriptor(APP));
    checkNoDuplicatedInstances(bundleDependencies);
    assertThat(bundleDependencies, contains(
                                            aBundleDependency(withArtifactId("lib-a").and().transitiveDependenciesThat(contains(
                                                                                                                                aBundleDependency(withArtifactId("lib-aa")
                                                                                                                                    .and()
                                                                                                                                    .transitiveDependenciesThat(contains(
                                                                                                                                                                         aBundleDependency(withArtifactId("plugin")
                                                                                                                                                                             .classifier(MULE_PLUGIN)
                                                                                                                                                                             .version("1.1.0")
                                                                                                                                                                             .and()
                                                                                                                                                                             .transitiveDependenciesThat(contains(
                                                                                                                                                                                                                  aBundleDependency(withArtifactId("plugin-shared-dep")
                                                                                                                                                                                                                      .version("1.0.0")),
                                                                                                                                                                                                                  aBundleDependency(withArtifactId("plugin-2-dep"))))))))))),
                                            aBundleDependency(withArtifactId("lib-aa").and().transitiveDependenciesThat(contains(
                                                                                                                                 aBundleDependency(withArtifactId("plugin")
                                                                                                                                     .classifier(MULE_PLUGIN)
                                                                                                                                     .version("1.1.0")
                                                                                                                                     .and()
                                                                                                                                     .transitiveDependenciesThat(contains(
                                                                                                                                                                          aBundleDependency(withArtifactId("plugin-shared-dep")
                                                                                                                                                                              .version("1.0.0")),
                                                                                                                                                                          aBundleDependency(withArtifactId("plugin-2-dep")))))))),
                                            aBundleDependency(withArtifactId("lib-b").and().transitiveDependenciesThat(contains(
                                                                                                                                aBundleDependency(withArtifactId("lib-bb")
                                                                                                                                    .and()
                                                                                                                                    .transitiveDependenciesThat(contains(
                                                                                                                                                                         aBundleDependency(withArtifactId("plugin")
                                                                                                                                                                             .classifier(MULE_PLUGIN)
                                                                                                                                                                             .version("1.1.0")
                                                                                                                                                                             .and()
                                                                                                                                                                             .transitiveDependenciesThat(contains(
                                                                                                                                                                                                                  aBundleDependency(withArtifactId("plugin-shared-dep")
                                                                                                                                                                                                                      .version("1.0.0")),
                                                                                                                                                                                                                  aBundleDependency(withArtifactId("plugin-2-dep"))))))))))),
                                            aBundleDependency(withArtifactId("lib-bb").and().transitiveDependenciesThat(contains(
                                                                                                                                 aBundleDependency(withArtifactId("plugin")
                                                                                                                                     .classifier(MULE_PLUGIN)
                                                                                                                                     .version("1.1.0")
                                                                                                                                     .and()
                                                                                                                                     .transitiveDependenciesThat(contains(
                                                                                                                                                                          aBundleDependency(withArtifactId("plugin-shared-dep")
                                                                                                                                                                              .version("1.0.0")),
                                                                                                                                                                          aBundleDependency(withArtifactId("plugin-2-dep")))))))),
                                            aBundleDependency(withArtifactId("plugin").classifier(MULE_PLUGIN).version("1.1.0")
                                                .and().transitiveDependenciesThat(contains(
                                                                                           aBundleDependency(withArtifactId("plugin-shared-dep")
                                                                                               .version("1.0.0")),
                                                                                           aBundleDependency(withArtifactId("plugin-2-dep")))))));
  }

  @Test
  public void pluginAsTransitiveOfLibraryFromPlugin() {
    //All plugins with the bigger version should win. And should be replaced inside transitive dependencies
    repositoryFolder.addArtifacts(
                                  artifact(APP).dependencies(
                                                             dependency("lib-a").dependencies(
                                                                                              dependency("plugin-a")
                                                                                                  .classifier(MULE_PLUGIN)
                                                                                                  .version("1.0.0").dependencies(
                                                                                                                                 dependency("lib-b")
                                                                                                                                     .dependencies(
                                                                                                                                                   dependency("plugin-b")
                                                                                                                                                       .classifier(MULE_PLUGIN)
                                                                                                                                                       .version("1.2.0")))),
                                                             dependency("plugin-a").classifier(MULE_PLUGIN).version("1.2.0")
                                                                 .dependencies(
                                                                               dependency("lib-c").dependencies(
                                                                                                                dependency("plugin-b")
                                                                                                                    .classifier(MULE_PLUGIN)
                                                                                                                    .version("1.0.0"))))
                                      .build());
    List<BundleDependency> bundleDependencies = mavenClient.resolveBundleDescriptorDependencies(false, getDescriptor(APP));
    checkNoDuplicatedInstances(bundleDependencies);
    assertThat(bundleDependencies, contains(
                                            aBundleDependency(withArtifactId("lib-a").and().transitiveDependenciesThat(contains(
                                                                                                                                aBundleDependency(withArtifactId("plugin-a")
                                                                                                                                    .version("1.2.0")
                                                                                                                                    .and()
                                                                                                                                    .transitiveDependenciesThat(contains(
                                                                                                                                                                         aBundleDependency(withArtifactId("lib-c")
                                                                                                                                                                             .and()
                                                                                                                                                                             .transitiveDependenciesThat(contains(
                                                                                                                                                                                                                  aBundleDependency(withArtifactId("plugin-b")
                                                                                                                                                                                                                      .version("1.0.0")
                                                                                                                                                                                                                      .and()
                                                                                                                                                                                                                      .transitiveDependenciesThat(hasSize(0)))))))))))),
                                            aBundleDependency(withArtifactId("plugin-a").version("1.2.0").and()
                                                .transitiveDependenciesThat(contains(
                                                                                     aBundleDependency(withArtifactId("lib-c")
                                                                                         .and()
                                                                                         .transitiveDependenciesThat(contains(
                                                                                                                              aBundleDependency(withArtifactId("plugin-b")
                                                                                                                                  .version("1.0.0")
                                                                                                                                  .and()
                                                                                                                                  .transitiveDependenciesThat(hasSize(0))))))))),
                                            aBundleDependency(withArtifactId("plugin-b").version("1.0.0").and()
                                                .transitiveDependenciesThat(hasSize(0)))));
  }

  @Test
  public void pluginDependenciesRemovesDuplicatesFromTransitiveDependenciesButLibrariesDont() {
    repositoryFolder.addArtifacts(
                                  artifact("app")
                                      .dependencies(
                                                    dependency("plugin")
                                                        .classifier(MULE_PLUGIN)
                                                        .dependencies(
                                                                      dependency("library-a")
                                                                          .dependencies(dependency("transitive-library")
                                                                              .version("1.0.0")),
                                                                      dependency("library-b")
                                                                          .dependencies(dependency("transitive-library")
                                                                              .version("2.0.0"))),
                                                    dependency("some-library")
                                                        .dependencies(
                                                                      dependency("library-a")
                                                                          .dependencies(dependency("transitive-library")
                                                                              .version("1.0.0")),
                                                                      dependency("library-b")
                                                                          .dependencies(dependency("transitive-library")
                                                                              .version("2.0.0"))))
                                      .build());
    List<BundleDependency> bundleDependencies = mavenClient.resolveBundleDescriptorDependencies(true, getDescriptor(APP));
    checkNoDuplicatedInstances(bundleDependencies);
    assertThat(bundleDependencies, contains(
                                            aBundleDependency(withArtifactId("plugin").classifier(MULE_PLUGIN).and()
                                                .transitiveDependenciesThat(
                                                                            contains(
                                                                                     aBundleDependency(withArtifactId("library-a")
                                                                                         .and()
                                                                                         .transitiveDependenciesThat(contains(
                                                                                                                              aBundleDependency(withArtifactId("transitive-library")
                                                                                                                                  .and()
                                                                                                                                  .version("1.0.0"))))),
                                                                                     aBundleDependency(withArtifactId("library-b")
                                                                                         .and()
                                                                                         .transitiveDependenciesThat(hasSize(0)))))),
                                            aBundleDependency(withArtifactId("some-library").and().transitiveDependenciesThat(
                                                                                                                              contains(
                                                                                                                                       aBundleDependency(withArtifactId("library-a")
                                                                                                                                           .and()
                                                                                                                                           .transitiveDependenciesThat(contains(
                                                                                                                                                                                aBundleDependency(withArtifactId("transitive-library")
                                                                                                                                                                                    .and()
                                                                                                                                                                                    .version("1.0.0"))))),
                                                                                                                                       aBundleDependency(withArtifactId("library-b")
                                                                                                                                           .and()
                                                                                                                                           .transitiveDependenciesThat(contains(
                                                                                                                                                                                aBundleDependency(withArtifactId("transitive-library")
                                                                                                                                                                                    .and()
                                                                                                                                                                                    .version("1.0.0")))))))),
                                            aBundleDependency(withArtifactId("library-a").and()
                                                .transitiveDependenciesThat(contains(
                                                                                     aBundleDependency(withArtifactId("transitive-library")
                                                                                         .and().version("1.0.0"))))),
                                            aBundleDependency(withArtifactId("transitive-library").and().version("1.0.0")),
                                            aBundleDependency(withArtifactId("library-b").and()
                                                .transitiveDependenciesThat(contains(
                                                                                     aBundleDependency(withArtifactId("transitive-library")
                                                                                         .and().version("1.0.0")))))));

  }

  @Test
  public void apiWithCommonDependencies() {
    repositoryFolder.addArtifacts(
                                  artifact(APP).dependencies(
                                                             dependency("api-a").classifier("raml").dependencies(
                                                                                                                 dependency("fragment")
                                                                                                                     .classifier("fragment")
                                                                                                                     .dependencies(
                                                                                                                                   dependency("lib")
                                                                                                                                       .version("1.0.0"))),
                                                             dependency("lib").version("1.2.0"))
                                      .build());
    List<BundleDependency> bundleDependencies = mavenClient.resolveBundleDescriptorDependencies(false, getDescriptor(APP));
    checkNoDuplicatedInstances(bundleDependencies);
    assertThat(bundleDependencies, contains(
                                            aBundleDependency(withArtifactId("api-a").and().transitiveDependenciesThat(contains(
                                                                                                                                aBundleDependency(withArtifactId("fragment")
                                                                                                                                    .and()
                                                                                                                                    .transitiveDependenciesThat(contains(
                                                                                                                                                                         aBundleDependency(withArtifactId("lib")
                                                                                                                                                                             .and()
                                                                                                                                                                             .version("1.2.0")))))))),
                                            aBundleDependency(withArtifactId("fragment").and()
                                                .transitiveDependenciesThat(contains(
                                                                                     aBundleDependency(withArtifactId("lib").and()
                                                                                         .version("1.2.0"))))),
                                            aBundleDependency(withArtifactId("lib").and().version("1.2.0"))));
  }

  @Test
  public void multipleCycles() {
    repositoryFolder.addArtifacts(
                                  artifact(APP).dependencies(
                                                             dependency("plugin-a").classifier(MULE_PLUGIN).dependencies(
                                                                                                                         dependency("lib-a")),
                                                             dependency("plugin-b").classifier(MULE_PLUGIN).dependencies(
                                                                                                                         dependency("lib-a")),
                                                             dependency("lib-a").dependencies(
                                                                                              dependency("lib-b").dependencies(
                                                                                                                               dependency("lib-c")
                                                                                                                                   .dependencies(
                                                                                                                                                 dependency("lib-d")
                                                                                                                                                     .dependencies(
                                                                                                                                                                   dependency("lib-a")))))

                                  ).build());
    List<BundleDependency> bundleDependencies = mavenClient.resolveBundleDescriptorDependencies(false, getDescriptor(APP));
    checkNoDuplicatedInstances(bundleDependencies);
    assertThat(bundleDependencies, contains(
                                            aBundleDependency(withArtifactId("plugin-a").and()
                                                .transitiveDependenciesThat(contains(
                                                                                     aBundleDependency(withArtifactId("lib-a")
                                                                                         .and()
                                                                                         .transitiveDependenciesThat(contains(
                                                                                                                              aBundleDependency(withArtifactId("lib-b")
                                                                                                                                  .and()
                                                                                                                                  .transitiveDependenciesThat(contains(
                                                                                                                                                                       aBundleDependency(withArtifactId("lib-c")
                                                                                                                                                                           .and()
                                                                                                                                                                           .transitiveDependenciesThat(contains(
                                                                                                                                                                                                                aBundleDependency(withArtifactId("lib-d")))))))))))))),
                                            aBundleDependency(withArtifactId("plugin-b").and()
                                                .transitiveDependenciesThat(contains(
                                                                                     aBundleDependency(withArtifactId("lib-a")
                                                                                         .and()
                                                                                         .transitiveDependenciesThat(contains(
                                                                                                                              aBundleDependency(withArtifactId("lib-b")
                                                                                                                                  .and()
                                                                                                                                  .transitiveDependenciesThat(contains(
                                                                                                                                                                       aBundleDependency(withArtifactId("lib-c")
                                                                                                                                                                           .and()
                                                                                                                                                                           .transitiveDependenciesThat(contains(
                                                                                                                                                                                                                aBundleDependency(withArtifactId("lib-d")))))))))))))),
                                            aBundleDependency(withArtifactId("lib-a").and().transitiveDependenciesThat(contains(
                                                                                                                                aBundleDependency(withArtifactId("lib-b")
                                                                                                                                    .and()
                                                                                                                                    .transitiveDependenciesThat(contains(
                                                                                                                                                                         aBundleDependency(withArtifactId("lib-c")
                                                                                                                                                                             .and()
                                                                                                                                                                             .transitiveDependenciesThat(contains(
                                                                                                                                                                                                                  aBundleDependency(withArtifactId("lib-d"))))))))))),
                                            aBundleDependency(withArtifactId("lib-b").and().transitiveDependenciesThat(contains(
                                                                                                                                aBundleDependency(withArtifactId("lib-c")
                                                                                                                                    .and()
                                                                                                                                    .transitiveDependenciesThat(contains(
                                                                                                                                                                         aBundleDependency(withArtifactId("lib-d")))))))),
                                            aBundleDependency(withArtifactId("lib-c").and().transitiveDependenciesThat(contains(
                                                                                                                                aBundleDependency(withArtifactId("lib-d"))))),
                                            aBundleDependency(withArtifactId("lib-d"))));
  }



}
