/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.test;

import static org.apache.commons.io.FileUtils.toFile;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.junit.Assert.assertThat;
import static org.mule.maven.client.api.model.MavenConfiguration.newMavenConfigurationBuilder;
import static org.mule.maven.client.test.AllureConstants.MavenClient.OnlineWithSettingsStory.ONLINE_STORY;

import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.MavenConfiguration;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import io.qameta.allure.Story;
import org.junit.Test;

@Story(ONLINE_STORY)
public class OnlineWithMavenSettingsTestCase extends AbstractOnlineMavenClientTestCase {

  @Override
  protected MavenConfiguration createMavenConfiguration() {
    return getMavenConfigurationBuilder().build();
  }

  private MavenConfiguration.MavenConfigurationBuilder getMavenConfigurationBuilder() {
    URL settingsUrl = getClass().getClassLoader().getResource("custom-settings.xml");
    return newMavenConfigurationBuilder()
        .localMavenRepositoryLocation(repositoryFolder.getRoot())
        .globalSettingsLocation(toFile(settingsUrl));
  }

  @Test
  public void resolveInstalledLocalBundleDescriptor() throws IOException {
    String groupId = "org.mule";
    String artifactId = "mule-core";
    String version = "3.3.0";
    String type = "pom";

    // First resolve the dependency online so it will be downloaded
    File localRepository = temporaryFolder.newFolder();
    mavenClient = mavenClientProvider.createMavenClient(getMavenConfigurationBuilder().localMavenRepositoryLocation(
                                                                                                                    localRepository)
        .build());
    BundleDependency resolved = mavenClient.resolveBundleDescriptor(new BundleDescriptor.Builder().setGroupId(groupId)
        .setArtifactId(artifactId)
        .setVersion(version)
        .setType(type).build());

    BundleDescriptor descriptor = resolved.getDescriptor();
    assertThat(descriptor.getGroupId(), equalTo(groupId));
    assertThat(descriptor.getArtifactId(), equalTo(artifactId));
    assertThat(descriptor.getVersion(), equalTo(version));
    assertThat(descriptor.getType(), equalTo(type));

    // Not try to resolve it with offline mode
    mavenClient =
        mavenClientProvider.createMavenClient(getMavenConfigurationBuilder().offlineMode(true).localMavenRepositoryLocation(
                                                                                                                            localRepository)
            .build());
    resolved = mavenClient.resolveBundleDescriptor(new BundleDescriptor.Builder().setGroupId(groupId)
        .setArtifactId(artifactId)
        .setVersion(version)
        .setType(type).build());

    descriptor = resolved.getDescriptor();
    assertThat(descriptor.getGroupId(), equalTo(groupId));
    assertThat(descriptor.getArtifactId(), equalTo(artifactId));
    assertThat(descriptor.getVersion(), equalTo(version));
    assertThat(descriptor.getType(), equalTo(type));

  }
}
