/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.pom.parser.api.model;

/**
 * Types of projects supported.
 *
 * @since 2.0.0
 */
public enum Classifier {

  MULE_APPLICATION, MULE_DOMAIN, MULE_PLUGIN;

  public static Classifier fromString(String name) {
    return valueOf(name.replace("-", "_").toUpperCase());
  }

  public boolean equals(String name) {
    if (name == null) {
      return false;
    }
    Classifier other;
    try {
      other = fromString(name);
    } catch (IllegalArgumentException e) {
      return false;
    }
    return other != null && other.equals(this);
  }

  @Override
  public String toString() {
    return name().replace("_", "-").toLowerCase();
  }
}
