/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.pom.parser.api.model;

import java.io.File;
import java.util.Optional;

/**
 *
 * Describes a Maven pom.
 *
 * @since 2.0.0
 */
public interface MavenPomModel {

  /**
   * Gets the pom parent of the Model.
   *
   * @return the parent
   */
  Optional<PomParentCoordinates> getParent();

  /**
   * Gets the group id of the Model.
   *
   * @return the group id
   */
  String getGroupId();

  /**
   * Gets the artifact id of the Model.
   *
   * @return the artifact id
   */
  String getArtifactId();

  /**
   * Gets the version of the Model.
   *
   * @return the version
   */
  String getVersion();

  /**
   * Gets packaging of the Model.
   *
   * @return the packaging or null if the packaging is not specify in the pom.
   */
  String getPackaging();

  /**
   * Gets the pom file.
   *
   * @return a {@link File} pointing to the pom if exists.
   */
  Optional<File> getPomFile();
}
