/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.pom.parser.api.model;

import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

import java.util.Arrays;
import java.util.List;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.junit.jupiter.params.provider.Arguments.arguments;

class ClassifierTestCase {

  /*
   * Awkward: we have a method 'equals' that overloads the standard 'equals'... can't rename because this is part of an api that
   * might be used who-knows-where
   */
  @ParameterizedTest
  @MethodSource("data")
  void testEquals(Classifier classifier, String testString, boolean expected) {
    assertThat(classifier.equals(testString), is(expected));
  }

  static List<Arguments> data() {
    return Arrays.asList(
                         arguments(Classifier.MULE_APPLICATION, "mule-application", true),
                         arguments(Classifier.MULE_DOMAIN, "mule-domain", true),
                         arguments(Classifier.MULE_PLUGIN, "mule-plugin", true),
                         arguments(Classifier.MULE_APPLICATION, "mule-application".toUpperCase(), true),
                         arguments(Classifier.MULE_APPLICATION, "foo", false),
                         arguments(Classifier.MULE_APPLICATION, null, false),
                         arguments(Classifier.MULE_APPLICATION, "mule-plugin", false));
  }
}
