/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.pom.parser.api.model;

import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

import java.util.List;

import static java.util.Arrays.asList;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.junit.jupiter.params.provider.Arguments.arguments;


class ArtifactCoordinatesTestCase {


  private static final String GROUP_ID = "groupId";
  private static final String GROUP_ID_2 = "groupId2";
  private static final String ARTIFACT_ID = "artifactId";
  private static final ArtifactCoordinates OTHER_GROUP = new ArtifactCoordinates(GROUP_ID_2, ARTIFACT_ID);
  private static final ArtifactCoordinates COORDINATES = new ArtifactCoordinates(GROUP_ID, ARTIFACT_ID);
  private static final String ARTIFACT_ID_2 = "artifactId2";
  private static final ArtifactCoordinates OTHER_ARTIFACT = new ArtifactCoordinates(GROUP_ID, ARTIFACT_ID_2);

  @ParameterizedTest(name = "{index}: equals for object")
  @MethodSource("equals_data")
  void testEquals(ArtifactCoordinates o1, Object o2, boolean expectedResult) {
    assertThat(o1.equals(o2), is(expectedResult));
  }

  @ParameterizedTest(name = "{index}: hashCode for object")
  @MethodSource("equals_data")
  void testHashCode(ArtifactCoordinates original, Object other, boolean expected) {
    assertThat(original.hashCode() == (other == null ? 0 : other.hashCode()), is(expected));
  }

  static List<Arguments> equals_data() {
    return asList(
                  arguments(COORDINATES, null, false),
                  arguments(COORDINATES, new Object(), false),
                  arguments(COORDINATES, COORDINATES, true),
                  // We do consider the group id
                  arguments(COORDINATES, OTHER_GROUP, false),
                  // We do consider the artifact id
                  arguments(COORDINATES, OTHER_ARTIFACT, false));
  }
}
