/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.pom.parser.api.model;

/**
 * Describes a ShareLibrary configuration.
 *
 * @since 2.0.0
 */
public class SharedLibrary {

  private final String groupId;

  private final String artifactId;

  /**
   * Instantiates a new ShareLibrary.
   *
   * @param groupId    the groupId
   * @param artifactId the artifactId
   */
  public SharedLibrary(String groupId, String artifactId) {
    this.groupId = groupId;
    this.artifactId = artifactId;
  }

  /**
   * Gets the artifactId.
   *
   * @return the artifact id
   */
  public String getArtifactId() {
    return artifactId;
  }

  /**
   * Gets the groupId.
   *
   * @return the group id
   */
  public String getGroupId() {
    return groupId;
  }
}
